/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.nb.rfc8040.rests.utils;

import com.google.common.collect.Maps;
import com.google.common.util.concurrent.FluentFuture;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.core.Response;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.restconf.common.context.InstanceIdentifierContext;
import org.opendaylight.restconf.common.context.NormalizedNodeContext;
import org.opendaylight.restconf.common.errors.RestconfDocumentedException;
import org.opendaylight.restconf.common.errors.RestconfError;
import org.opendaylight.restconf.common.validation.RestconfValidationUtils;
import org.opendaylight.restconf.nb.rfc8040.handlers.TransactionChainHandler;
import org.opendaylight.restconf.nb.rfc8040.references.SchemaContextRef;
import org.opendaylight.restconf.nb.rfc8040.rests.transactions.TransactionVarsWrapper;
import org.opendaylight.restconf.nb.rfc8040.rests.utils.FutureCallbackTx;
import org.opendaylight.restconf.nb.rfc8040.rests.utils.FutureDataFactory;
import org.opendaylight.restconf.nb.rfc8040.rests.utils.ReadDataTransactionUtil;
import org.opendaylight.restconf.nb.rfc8040.rests.utils.ResponseFactory;
import org.opendaylight.restconf.nb.rfc8040.rests.utils.RestconfDataServiceConstant;
import org.opendaylight.restconf.nb.rfc8040.rests.utils.TransactionUtil;
import org.opendaylight.restconf.nb.rfc8040.utils.parser.ParserIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.OrderedLeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.OrderedMapNode;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextNode;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextTree;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;

public final class PutDataTransactionUtil {
    private PutDataTransactionUtil() {
    }

    public static void validInputData(SchemaNode schemaNode, NormalizedNodeContext payload) {
        if (schemaNode != null && payload.getData() == null) {
            throw new RestconfDocumentedException("Input is required.", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.MALFORMED_MESSAGE);
        }
        if (schemaNode == null && payload.getData() != null) {
            throw new RestconfDocumentedException("No input expected.", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.MALFORMED_MESSAGE);
        }
    }

    public static void validTopLevelNodeName(YangInstanceIdentifier path, NormalizedNodeContext payload) {
        String payloadName = payload.getData().getNodeType().getLocalName();
        if (path.isEmpty()) {
            if (!payload.getData().getNodeType().equals((Object)RestconfDataServiceConstant.NETCONF_BASE_QNAME)) {
                throw new RestconfDocumentedException("Instance identifier has to contain at least one path argument", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.MALFORMED_MESSAGE);
            }
        } else {
            String identifierName = path.getLastPathArgument().getNodeType().getLocalName();
            if (!payloadName.equals(identifierName)) {
                throw new RestconfDocumentedException("Payload name (" + payloadName + ") is different from identifier name (" + identifierName + ")", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.MALFORMED_MESSAGE);
            }
        }
    }

    public static void validateListKeysEqualityInPayloadAndUri(NormalizedNodeContext payload) {
        InstanceIdentifierContext iiWithData = payload.getInstanceIdentifierContext();
        YangInstanceIdentifier.PathArgument lastPathArgument = iiWithData.getInstanceIdentifier().getLastPathArgument();
        SchemaNode schemaNode = iiWithData.getSchemaNode();
        NormalizedNode data = payload.getData();
        if (schemaNode instanceof ListSchemaNode) {
            List keyDefinitions = ((ListSchemaNode)schemaNode).getKeyDefinition();
            if (lastPathArgument instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates && data instanceof MapEntryNode) {
                Map uriKeyValues = ((YangInstanceIdentifier.NodeIdentifierWithPredicates)lastPathArgument).getKeyValues();
                PutDataTransactionUtil.isEqualUriAndPayloadKeyValues(uriKeyValues, (MapEntryNode)data, keyDefinitions);
            }
        }
    }

    private static void isEqualUriAndPayloadKeyValues(Map<QName, Object> uriKeyValues, MapEntryNode payload, List<QName> keyDefinitions) {
        HashMap mutableCopyUriKeyValues = Maps.newHashMap(uriKeyValues);
        for (QName keyDefinition : keyDefinitions) {
            Object uriKeyValue = mutableCopyUriKeyValues.remove(keyDefinition);
            RestconfValidationUtils.checkDocumentedError((uriKeyValue != null ? 1 : 0) != 0, (RestconfError.ErrorType)RestconfError.ErrorType.PROTOCOL, (RestconfError.ErrorTag)RestconfError.ErrorTag.DATA_MISSING, (String)("Missing key " + keyDefinition + " in URI."));
            Object dataKeyValue = payload.getIdentifier().getKeyValues().get(keyDefinition);
            if (uriKeyValue.equals(dataKeyValue)) continue;
            String errMsg = "The value '" + uriKeyValue + "' for key '" + keyDefinition.getLocalName() + "' specified in the URI doesn't match the value '" + dataKeyValue + "' specified in the message body. ";
            throw new RestconfDocumentedException(errMsg, RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.INVALID_VALUE);
        }
    }

    public static Response putData(NormalizedNodeContext payload, SchemaContextRef schemaCtxRef, TransactionVarsWrapper transactionNode, String insert, String point) {
        YangInstanceIdentifier path = payload.getInstanceIdentifierContext().getInstanceIdentifier();
        SchemaContext schemaContext = schemaCtxRef.get();
        DOMDataTreeReadWriteTransaction readWriteTransaction = transactionNode.getTransactionChain().newReadWriteTransaction();
        FluentFuture existsFuture = readWriteTransaction.exists(LogicalDatastoreType.CONFIGURATION, path);
        FutureDataFactory existsResponse = new FutureDataFactory();
        FutureCallbackTx.addCallback(existsFuture, "PUT", existsResponse);
        ResponseFactory responseFactory = new ResponseFactory((Boolean)existsResponse.result != false ? Response.Status.NO_CONTENT : Response.Status.CREATED);
        FluentFuture<? extends CommitInfo> submitData = PutDataTransactionUtil.submitData(path, schemaContext, transactionNode.getTransactionChainHandler(), readWriteTransaction, payload.getData(), insert, point);
        FutureCallbackTx.addCallback(submitData, "PUT", responseFactory);
        return responseFactory.build();
    }

    private static FluentFuture<? extends CommitInfo> submitData(YangInstanceIdentifier path, SchemaContext schemaContext, TransactionChainHandler transactionChainHandler, DOMDataTreeReadWriteTransaction readWriteTransaction, NormalizedNode<?, ?> data, String insert, String point) {
        if (insert == null) {
            return PutDataTransactionUtil.makePut(path, schemaContext, (DOMDataTreeWriteTransaction)readWriteTransaction, data);
        }
        DataSchemaNode schemaNode = PutDataTransactionUtil.checkListAndOrderedType(schemaContext, path);
        switch (insert) {
            case "first": {
                if (schemaNode instanceof ListSchemaNode) {
                    NormalizedNode<?, ?> readData = PutDataTransactionUtil.readList(path, schemaContext, transactionChainHandler, schemaNode);
                    OrderedMapNode readList = (OrderedMapNode)readData;
                    if (readList == null || readList.getValue().isEmpty()) {
                        return PutDataTransactionUtil.makePut(path, schemaContext, (DOMDataTreeWriteTransaction)readWriteTransaction, data);
                    }
                    readWriteTransaction.delete(LogicalDatastoreType.CONFIGURATION, path.getParent());
                    PutDataTransactionUtil.simplePut(LogicalDatastoreType.CONFIGURATION, path, (DOMDataTreeWriteTransaction)readWriteTransaction, schemaContext, data);
                    PutDataTransactionUtil.listPut(LogicalDatastoreType.CONFIGURATION, path.getParent(), (DOMDataTreeWriteTransaction)readWriteTransaction, schemaContext, readList);
                    return readWriteTransaction.commit();
                }
                NormalizedNode<?, ?> readData = PutDataTransactionUtil.readList(path, schemaContext, transactionChainHandler, schemaNode);
                OrderedLeafSetNode readLeafList = (OrderedLeafSetNode)readData;
                if (readLeafList == null || readLeafList.getValue().isEmpty()) {
                    return PutDataTransactionUtil.makePut(path, schemaContext, (DOMDataTreeWriteTransaction)readWriteTransaction, data);
                }
                readWriteTransaction.delete(LogicalDatastoreType.CONFIGURATION, path.getParent());
                PutDataTransactionUtil.simplePut(LogicalDatastoreType.CONFIGURATION, path, (DOMDataTreeWriteTransaction)readWriteTransaction, schemaContext, data);
                PutDataTransactionUtil.listPut(LogicalDatastoreType.CONFIGURATION, path.getParent(), (DOMDataTreeWriteTransaction)readWriteTransaction, schemaContext, readLeafList);
                return readWriteTransaction.commit();
            }
            case "last": {
                return PutDataTransactionUtil.makePut(path, schemaContext, (DOMDataTreeWriteTransaction)readWriteTransaction, data);
            }
            case "before": {
                if (schemaNode instanceof ListSchemaNode) {
                    NormalizedNode<?, ?> readData = PutDataTransactionUtil.readList(path, schemaContext, transactionChainHandler, schemaNode);
                    OrderedMapNode readList = (OrderedMapNode)readData;
                    if (readList == null || readList.getValue().isEmpty()) {
                        return PutDataTransactionUtil.makePut(path, schemaContext, (DOMDataTreeWriteTransaction)readWriteTransaction, data);
                    }
                    PutDataTransactionUtil.insertWithPointListPut(readWriteTransaction, LogicalDatastoreType.CONFIGURATION, path, data, schemaContext, point, readList, true);
                    return readWriteTransaction.commit();
                }
                NormalizedNode<?, ?> readData = PutDataTransactionUtil.readList(path, schemaContext, transactionChainHandler, schemaNode);
                OrderedLeafSetNode readLeafList = (OrderedLeafSetNode)readData;
                if (readLeafList == null || readLeafList.getValue().isEmpty()) {
                    return PutDataTransactionUtil.makePut(path, schemaContext, (DOMDataTreeWriteTransaction)readWriteTransaction, data);
                }
                PutDataTransactionUtil.insertWithPointLeafListPut(readWriteTransaction, LogicalDatastoreType.CONFIGURATION, path, data, schemaContext, point, readLeafList, true);
                return readWriteTransaction.commit();
            }
            case "after": {
                if (schemaNode instanceof ListSchemaNode) {
                    NormalizedNode<?, ?> readData = PutDataTransactionUtil.readList(path, schemaContext, transactionChainHandler, schemaNode);
                    OrderedMapNode readList = (OrderedMapNode)readData;
                    if (readList == null || readList.getValue().isEmpty()) {
                        return PutDataTransactionUtil.makePut(path, schemaContext, (DOMDataTreeWriteTransaction)readWriteTransaction, data);
                    }
                    PutDataTransactionUtil.insertWithPointListPut(readWriteTransaction, LogicalDatastoreType.CONFIGURATION, path, data, schemaContext, point, readList, false);
                    return readWriteTransaction.commit();
                }
                NormalizedNode<?, ?> readData = PutDataTransactionUtil.readList(path, schemaContext, transactionChainHandler, schemaNode);
                OrderedLeafSetNode readLeafList = (OrderedLeafSetNode)readData;
                if (readLeafList == null || readLeafList.getValue().isEmpty()) {
                    return PutDataTransactionUtil.makePut(path, schemaContext, (DOMDataTreeWriteTransaction)readWriteTransaction, data);
                }
                PutDataTransactionUtil.insertWithPointLeafListPut(readWriteTransaction, LogicalDatastoreType.CONFIGURATION, path, data, schemaContext, point, readLeafList, true);
                return readWriteTransaction.commit();
            }
        }
        throw new RestconfDocumentedException("Used bad value of insert parameter. Possible values are first, last, before or after, but was: " + insert);
    }

    public static NormalizedNode<?, ?> readList(YangInstanceIdentifier path, SchemaContext schemaContext, TransactionChainHandler transactionChainHandler, DataSchemaNode schemaNode) {
        InstanceIdentifierContext iid = new InstanceIdentifierContext(path.getParent(), (SchemaNode)schemaNode, null, schemaContext);
        TransactionVarsWrapper transactionNode = new TransactionVarsWrapper(iid, null, transactionChainHandler);
        NormalizedNode<?, ?> readData = ReadDataTransactionUtil.readData("config", transactionNode, schemaContext);
        return readData;
    }

    private static void insertWithPointLeafListPut(DOMDataTreeReadWriteTransaction rwTransaction, LogicalDatastoreType datastore, YangInstanceIdentifier path, NormalizedNode<?, ?> data, SchemaContext schemaContext, String point, OrderedLeafSetNode<?> readLeafList, boolean before) {
        LeafSetEntryNode nodeChild;
        rwTransaction.delete(datastore, path.getParent());
        InstanceIdentifierContext<?> instanceIdentifier = ParserIdentifier.toInstanceIdentifier(point, schemaContext, Optional.empty());
        int lastItemPosition = 0;
        Iterator iterator = readLeafList.getValue().iterator();
        while (iterator.hasNext() && !(nodeChild = (LeafSetEntryNode)iterator.next()).getIdentifier().equals((Object)instanceIdentifier.getInstanceIdentifier().getLastPathArgument())) {
            ++lastItemPosition;
        }
        if (!before) {
            ++lastItemPosition;
        }
        int lastInsertedPosition = 0;
        NormalizedNode emptySubtree = ImmutableNodes.fromInstanceId((SchemaContext)schemaContext, (YangInstanceIdentifier)path.getParent());
        rwTransaction.merge(datastore, YangInstanceIdentifier.create((YangInstanceIdentifier.PathArgument[])new YangInstanceIdentifier.PathArgument[]{emptySubtree.getIdentifier()}), emptySubtree);
        for (LeafSetEntryNode nodeChild2 : readLeafList.getValue()) {
            if (lastInsertedPosition == lastItemPosition) {
                PutDataTransactionUtil.simplePut(datastore, path, (DOMDataTreeWriteTransaction)rwTransaction, schemaContext, data);
            }
            YangInstanceIdentifier childPath = path.getParent().node((YangInstanceIdentifier.PathArgument)nodeChild2.getIdentifier());
            rwTransaction.put(datastore, childPath, (NormalizedNode)nodeChild2);
            ++lastInsertedPosition;
        }
    }

    private static void insertWithPointListPut(DOMDataTreeReadWriteTransaction writeTx, LogicalDatastoreType datastore, YangInstanceIdentifier path, NormalizedNode<?, ?> data, SchemaContext schemaContext, String point, OrderedMapNode readList, boolean before) {
        MapEntryNode mapEntryNode;
        writeTx.delete(datastore, path.getParent());
        InstanceIdentifierContext<?> instanceIdentifier = ParserIdentifier.toInstanceIdentifier(point, schemaContext, Optional.empty());
        int lastItemPosition = 0;
        Iterator iterator = readList.getValue().iterator();
        while (iterator.hasNext() && !(mapEntryNode = (MapEntryNode)iterator.next()).getIdentifier().equals((Object)instanceIdentifier.getInstanceIdentifier().getLastPathArgument())) {
            ++lastItemPosition;
        }
        if (!before) {
            ++lastItemPosition;
        }
        int lastInsertedPosition = 0;
        NormalizedNode emptySubtree = ImmutableNodes.fromInstanceId((SchemaContext)schemaContext, (YangInstanceIdentifier)path.getParent());
        writeTx.merge(datastore, YangInstanceIdentifier.create((YangInstanceIdentifier.PathArgument[])new YangInstanceIdentifier.PathArgument[]{emptySubtree.getIdentifier()}), emptySubtree);
        for (MapEntryNode mapEntryNode2 : readList.getValue()) {
            if (lastInsertedPosition == lastItemPosition) {
                PutDataTransactionUtil.simplePut(datastore, path, (DOMDataTreeWriteTransaction)writeTx, schemaContext, data);
            }
            YangInstanceIdentifier childPath = path.getParent().node((YangInstanceIdentifier.PathArgument)mapEntryNode2.getIdentifier());
            writeTx.put(datastore, childPath, (NormalizedNode)mapEntryNode2);
            ++lastInsertedPosition;
        }
    }

    private static void listPut(LogicalDatastoreType datastore, YangInstanceIdentifier path, DOMDataTreeWriteTransaction writeTx, SchemaContext schemaContext, OrderedLeafSetNode<?> payload) {
        NormalizedNode emptySubtree = ImmutableNodes.fromInstanceId((SchemaContext)schemaContext, (YangInstanceIdentifier)path);
        writeTx.merge(datastore, YangInstanceIdentifier.create((YangInstanceIdentifier.PathArgument[])new YangInstanceIdentifier.PathArgument[]{emptySubtree.getIdentifier()}), emptySubtree);
        TransactionUtil.ensureParentsByMerge(path, schemaContext, writeTx);
        for (LeafSetEntryNode child : payload.getValue()) {
            YangInstanceIdentifier childPath = path.node((YangInstanceIdentifier.PathArgument)child.getIdentifier());
            writeTx.put(datastore, childPath, (NormalizedNode)child);
        }
    }

    private static void listPut(LogicalDatastoreType datastore, YangInstanceIdentifier path, DOMDataTreeWriteTransaction writeTx, SchemaContext schemaContext, OrderedMapNode payload) {
        NormalizedNode emptySubtree = ImmutableNodes.fromInstanceId((SchemaContext)schemaContext, (YangInstanceIdentifier)path);
        writeTx.merge(datastore, YangInstanceIdentifier.create((YangInstanceIdentifier.PathArgument[])new YangInstanceIdentifier.PathArgument[]{emptySubtree.getIdentifier()}), emptySubtree);
        TransactionUtil.ensureParentsByMerge(path, schemaContext, writeTx);
        for (MapEntryNode child : payload.getValue()) {
            YangInstanceIdentifier childPath = path.node((YangInstanceIdentifier.PathArgument)child.getIdentifier());
            writeTx.put(datastore, childPath, (NormalizedNode)child);
        }
    }

    private static void simplePut(LogicalDatastoreType configuration, YangInstanceIdentifier path, DOMDataTreeWriteTransaction writeTx, SchemaContext schemaContext, NormalizedNode<?, ?> data) {
        TransactionUtil.ensureParentsByMerge(path, schemaContext, writeTx);
        writeTx.put(LogicalDatastoreType.CONFIGURATION, path, data);
    }

    private static FluentFuture<? extends CommitInfo> makePut(YangInstanceIdentifier path, SchemaContext schemaContext, DOMDataTreeWriteTransaction writeTx, NormalizedNode<?, ?> data) {
        TransactionUtil.ensureParentsByMerge(path, schemaContext, writeTx);
        writeTx.put(LogicalDatastoreType.CONFIGURATION, path, data);
        return writeTx.commit();
    }

    public static DataSchemaNode checkListAndOrderedType(SchemaContext ctx, YangInstanceIdentifier path) {
        YangInstanceIdentifier parent = path.getParent();
        DataSchemaContextNode node = DataSchemaContextTree.from((SchemaContext)ctx).getChild(parent);
        DataSchemaNode dataSchemaNode = node.getDataSchemaNode();
        if (dataSchemaNode instanceof ListSchemaNode) {
            if (!((ListSchemaNode)dataSchemaNode).isUserOrdered()) {
                throw new RestconfDocumentedException("Insert parameter can be used only with ordered-by user list.");
            }
            return dataSchemaNode;
        }
        if (dataSchemaNode instanceof LeafListSchemaNode) {
            if (!((LeafListSchemaNode)dataSchemaNode).isUserOrdered()) {
                throw new RestconfDocumentedException("Insert parameter can be used only with ordered-by user leaf-list.");
            }
            return dataSchemaNode;
        }
        throw new RestconfDocumentedException("Insert parameter can be used only with list or leaf-list");
    }
}

