/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.nb.rfc8040.rests.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FluentFuture;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.restconf.common.errors.RestconfDocumentedException;
import org.opendaylight.restconf.common.errors.RestconfError;
import org.opendaylight.restconf.common.patch.PatchContext;
import org.opendaylight.restconf.common.patch.PatchEntity;
import org.opendaylight.restconf.common.patch.PatchStatusContext;
import org.opendaylight.restconf.common.patch.PatchStatusEntity;
import org.opendaylight.restconf.nb.rfc8040.references.SchemaContextRef;
import org.opendaylight.restconf.nb.rfc8040.rests.transactions.TransactionVarsWrapper;
import org.opendaylight.restconf.nb.rfc8040.rests.utils.FutureCallbackTx;
import org.opendaylight.restconf.nb.rfc8040.rests.utils.FutureDataFactory;
import org.opendaylight.restconf.nb.rfc8040.rests.utils.ResponseFactory;
import org.opendaylight.restconf.nb.rfc8040.rests.utils.TransactionUtil;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PatchDataTransactionUtil {
    private static final Logger LOG = LoggerFactory.getLogger(PatchDataTransactionUtil.class);

    private PatchDataTransactionUtil() {
        throw new UnsupportedOperationException("Util class.");
    }

    public static PatchStatusContext patchData(PatchContext context, TransactionVarsWrapper transactionNode, SchemaContextRef schemaContextRef) {
        ArrayList<PatchStatusEntity> editCollection = new ArrayList<PatchStatusEntity>();
        boolean noError = true;
        DOMDataTreeReadWriteTransaction tx = transactionNode.getTransactionChain().newReadWriteTransaction();
        block19: for (PatchEntity patchEntity : context.getData()) {
            if (!noError) break;
            switch (patchEntity.getOperation()) {
                case CREATE: {
                    try {
                        PatchDataTransactionUtil.createDataWithinTransaction(LogicalDatastoreType.CONFIGURATION, patchEntity.getTargetNode(), patchEntity.getNode(), tx, schemaContextRef);
                        editCollection.add(new PatchStatusEntity(patchEntity.getEditId(), true, null));
                    }
                    catch (RestconfDocumentedException e) {
                        editCollection.add(new PatchStatusEntity(patchEntity.getEditId(), false, (List)Lists.newArrayList((Iterable)e.getErrors())));
                        noError = false;
                    }
                    continue block19;
                }
                case DELETE: {
                    try {
                        PatchDataTransactionUtil.deleteDataWithinTransaction(LogicalDatastoreType.CONFIGURATION, patchEntity.getTargetNode(), tx);
                        editCollection.add(new PatchStatusEntity(patchEntity.getEditId(), true, null));
                    }
                    catch (RestconfDocumentedException e) {
                        editCollection.add(new PatchStatusEntity(patchEntity.getEditId(), false, (List)Lists.newArrayList((Iterable)e.getErrors())));
                        noError = false;
                    }
                    continue block19;
                }
                case MERGE: {
                    try {
                        PatchDataTransactionUtil.mergeDataWithinTransaction(LogicalDatastoreType.CONFIGURATION, patchEntity.getTargetNode(), patchEntity.getNode(), (DOMDataTreeWriteTransaction)tx, schemaContextRef);
                        editCollection.add(new PatchStatusEntity(patchEntity.getEditId(), true, null));
                    }
                    catch (RestconfDocumentedException e) {
                        editCollection.add(new PatchStatusEntity(patchEntity.getEditId(), false, (List)Lists.newArrayList((Iterable)e.getErrors())));
                        noError = false;
                    }
                    continue block19;
                }
                case REPLACE: {
                    try {
                        PatchDataTransactionUtil.replaceDataWithinTransaction(LogicalDatastoreType.CONFIGURATION, patchEntity.getTargetNode(), patchEntity.getNode(), schemaContextRef, tx);
                        editCollection.add(new PatchStatusEntity(patchEntity.getEditId(), true, null));
                    }
                    catch (RestconfDocumentedException e) {
                        editCollection.add(new PatchStatusEntity(patchEntity.getEditId(), false, (List)Lists.newArrayList((Iterable)e.getErrors())));
                        noError = false;
                    }
                    continue block19;
                }
                case REMOVE: {
                    try {
                        PatchDataTransactionUtil.removeDataWithinTransaction(LogicalDatastoreType.CONFIGURATION, patchEntity.getTargetNode(), (DOMDataTreeWriteTransaction)tx);
                        editCollection.add(new PatchStatusEntity(patchEntity.getEditId(), true, null));
                    }
                    catch (RestconfDocumentedException e) {
                        editCollection.add(new PatchStatusEntity(patchEntity.getEditId(), false, (List)Lists.newArrayList((Iterable)e.getErrors())));
                        noError = false;
                    }
                    continue block19;
                }
            }
            editCollection.add(new PatchStatusEntity(patchEntity.getEditId(), false, (List)Lists.newArrayList((Object[])new RestconfError[]{new RestconfError(RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.OPERATION_NOT_SUPPORTED, "Not supported Yang Patch operation")})));
            noError = false;
        }
        if (noError) {
            ResponseFactory response = new ResponseFactory(Response.Status.OK);
            FluentFuture future = tx.commit();
            try {
                FutureCallbackTx.addCallback(future, "Patch", response);
            }
            catch (RestconfDocumentedException e) {
                return new PatchStatusContext(context.getPatchId(), (List)ImmutableList.copyOf(editCollection), false, (List)Lists.newArrayList((Iterable)e.getErrors()));
            }
            return new PatchStatusContext(context.getPatchId(), (List)ImmutableList.copyOf(editCollection), true, null);
        }
        tx.cancel();
        transactionNode.getTransactionChainHandler().reset();
        return new PatchStatusContext(context.getPatchId(), (List)ImmutableList.copyOf(editCollection), false, null);
    }

    private static void createDataWithinTransaction(LogicalDatastoreType dataStore, YangInstanceIdentifier path, NormalizedNode<?, ?> payload, DOMDataTreeReadWriteTransaction rwTransaction, SchemaContextRef schemaContextRef) {
        LOG.trace("POST {} within Restconf Patch: {} with payload {}", new Object[]{dataStore.name(), path, payload});
        PatchDataTransactionUtil.createData(payload, schemaContextRef.get(), path, rwTransaction, dataStore, true);
    }

    private static void deleteDataWithinTransaction(LogicalDatastoreType dataStore, YangInstanceIdentifier path, DOMDataTreeReadWriteTransaction readWriteTransaction) {
        LOG.trace("Delete {} within Restconf Patch: {}", (Object)dataStore.name(), (Object)path);
        PatchDataTransactionUtil.checkItemExistsWithinTransaction((DOMDataTreeReadTransaction)readWriteTransaction, dataStore, path);
        readWriteTransaction.delete(dataStore, path);
    }

    private static void mergeDataWithinTransaction(LogicalDatastoreType dataStore, YangInstanceIdentifier path, NormalizedNode<?, ?> payload, DOMDataTreeWriteTransaction writeTransaction, SchemaContextRef schemaContextRef) {
        LOG.trace("Merge {} within Restconf Patch: {} with payload {}", new Object[]{dataStore.name(), path, payload});
        TransactionUtil.ensureParentsByMerge(path, schemaContextRef.get(), writeTransaction);
        writeTransaction.merge(dataStore, path, payload);
    }

    private static void removeDataWithinTransaction(LogicalDatastoreType dataStore, YangInstanceIdentifier path, DOMDataTreeWriteTransaction writeTransaction) {
        LOG.trace("Remove {} within Restconf Patch: {}", (Object)dataStore.name(), (Object)path);
        writeTransaction.delete(dataStore, path);
    }

    private static void replaceDataWithinTransaction(LogicalDatastoreType dataStore, YangInstanceIdentifier path, NormalizedNode<?, ?> payload, SchemaContextRef schemaContextRef, DOMDataTreeReadWriteTransaction rwTransaction) {
        LOG.trace("PUT {} within Restconf Patch: {} with payload {}", new Object[]{dataStore.name(), path, payload});
        PatchDataTransactionUtil.createData(payload, schemaContextRef.get(), path, rwTransaction, dataStore, false);
    }

    private static void createData(NormalizedNode<?, ?> payload, SchemaContext schemaContext, YangInstanceIdentifier path, DOMDataTreeReadWriteTransaction rwTransaction, LogicalDatastoreType dataStore, boolean errorIfExists) {
        if (payload instanceof MapNode) {
            NormalizedNode emptySubtree = ImmutableNodes.fromInstanceId((SchemaContext)schemaContext, (YangInstanceIdentifier)path);
            rwTransaction.merge(dataStore, YangInstanceIdentifier.create((YangInstanceIdentifier.PathArgument[])new YangInstanceIdentifier.PathArgument[]{emptySubtree.getIdentifier()}), emptySubtree);
            TransactionUtil.ensureParentsByMerge(path, schemaContext, (DOMDataTreeWriteTransaction)rwTransaction);
            for (MapEntryNode child : ((MapNode)payload).getValue()) {
                YangInstanceIdentifier childPath = path.node((YangInstanceIdentifier.PathArgument)child.getIdentifier());
                if (errorIfExists) {
                    PatchDataTransactionUtil.checkItemDoesNotExistsWithinTransaction((DOMDataTreeReadTransaction)rwTransaction, dataStore, childPath);
                }
                rwTransaction.put(dataStore, childPath, (NormalizedNode)child);
            }
        } else {
            if (errorIfExists) {
                PatchDataTransactionUtil.checkItemDoesNotExistsWithinTransaction((DOMDataTreeReadTransaction)rwTransaction, dataStore, path);
            }
            TransactionUtil.ensureParentsByMerge(path, schemaContext, (DOMDataTreeWriteTransaction)rwTransaction);
            rwTransaction.put(dataStore, path, payload);
        }
    }

    public static void checkItemExistsWithinTransaction(DOMDataTreeReadTransaction rwTransaction, LogicalDatastoreType store, YangInstanceIdentifier path) {
        FluentFuture future = rwTransaction.exists(store, path);
        FutureDataFactory response = new FutureDataFactory();
        FutureCallbackTx.addCallback(future, "Patch", response);
        if (!((Boolean)response.result).booleanValue()) {
            LOG.trace("Operation via Restconf was not executed because data at {} does not exist", (Object)path);
            throw new RestconfDocumentedException("Data does not exist", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.DATA_MISSING, path);
        }
    }

    public static void checkItemDoesNotExistsWithinTransaction(DOMDataTreeReadTransaction rwTransaction, LogicalDatastoreType store, YangInstanceIdentifier path) {
        FluentFuture future = rwTransaction.exists(store, path);
        FutureDataFactory response = new FutureDataFactory();
        FutureCallbackTx.addCallback(future, "Patch", response);
        if (((Boolean)response.result).booleanValue()) {
            LOG.trace("Operation via Restconf was not executed because data at {} already exists", (Object)path);
            throw new RestconfDocumentedException("Data already exists", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.DATA_EXISTS, path);
        }
    }
}

