/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.nb.rfc8040.rests.utils;

import com.google.common.util.concurrent.FluentFuture;
import javax.ws.rs.core.Response;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadWriteTransaction;
import org.opendaylight.restconf.nb.rfc8040.handlers.TransactionChainHandler;
import org.opendaylight.restconf.nb.rfc8040.rests.transactions.TransactionVarsWrapper;
import org.opendaylight.restconf.nb.rfc8040.rests.utils.FutureCallbackTx;
import org.opendaylight.restconf.nb.rfc8040.rests.utils.ResponseFactory;
import org.opendaylight.restconf.nb.rfc8040.rests.utils.TransactionUtil;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

public final class DeleteDataTransactionUtil {
    private DeleteDataTransactionUtil() {
        throw new UnsupportedOperationException("Util class.");
    }

    public static Response deleteData(TransactionVarsWrapper transactionNode) {
        FluentFuture<? extends CommitInfo> future = DeleteDataTransactionUtil.submitData(transactionNode.getTransactionChainHandler(), transactionNode.getInstanceIdentifier().getInstanceIdentifier());
        ResponseFactory response = new ResponseFactory(Response.Status.NO_CONTENT);
        FutureCallbackTx.addCallback(future, "DELETE", response);
        return response.build();
    }

    private static FluentFuture<? extends CommitInfo> submitData(TransactionChainHandler transactionChainHandler, YangInstanceIdentifier path) {
        DOMDataTreeReadWriteTransaction readWriteTx = transactionChainHandler.get().newReadWriteTransaction();
        TransactionUtil.checkItemExists(transactionChainHandler, readWriteTx, LogicalDatastoreType.CONFIGURATION, path, "DELETE");
        readWriteTx.delete(LogicalDatastoreType.CONFIGURATION, path);
        return readWriteTx.commit();
    }
}

