/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.nb.rfc8040.rests.services.impl;

import java.net.URI;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.ws.rs.Path;
import javax.ws.rs.core.UriInfo;
import org.opendaylight.restconf.common.context.InstanceIdentifierContext;
import org.opendaylight.restconf.common.context.NormalizedNodeContext;
import org.opendaylight.restconf.common.errors.RestconfDocumentedException;
import org.opendaylight.restconf.nb.rfc8040.handlers.DOMDataBrokerHandler;
import org.opendaylight.restconf.nb.rfc8040.handlers.NotificationServiceHandler;
import org.opendaylight.restconf.nb.rfc8040.handlers.SchemaContextHandler;
import org.opendaylight.restconf.nb.rfc8040.handlers.TransactionChainHandler;
import org.opendaylight.restconf.nb.rfc8040.rests.services.api.RestconfStreamsSubscriptionService;
import org.opendaylight.restconf.nb.rfc8040.rests.utils.RestconfStreamsConstants;
import org.opendaylight.restconf.nb.rfc8040.rests.utils.SubscribeToStreamUtil;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.NormalizedNodeAttrBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableLeafNodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class RestconfStreamsSubscriptionServiceImpl
implements RestconfStreamsSubscriptionService {
    private static final Logger LOG = LoggerFactory.getLogger(RestconfStreamsSubscriptionServiceImpl.class);
    private HandlersHolder handlersHolder;

    public RestconfStreamsSubscriptionServiceImpl(DOMDataBrokerHandler domDataBrokerHandler, NotificationServiceHandler notificationServiceHandler, SchemaContextHandler schemaHandler, TransactionChainHandler transactionChainHandler) {
        this.handlersHolder = new HandlersHolder(domDataBrokerHandler, notificationServiceHandler, transactionChainHandler, schemaHandler);
    }

    @Override
    public synchronized void updateHandlers(Object ... handlers) {
        for (Object object : handlers) {
            if (!(object instanceof HandlersHolder)) continue;
            this.handlersHolder = (HandlersHolder)object;
        }
    }

    @Override
    public NormalizedNodeContext subscribeToStream(String identifier, UriInfo uriInfo) {
        NotificationQueryParams notificationQueryParams = NotificationQueryParams.fromUriInfo(uriInfo);
        URI response = null;
        if (identifier.contains(RestconfStreamsConstants.DATA_SUBSCR)) {
            response = SubscribeToStreamUtil.notifiDataStream(identifier, uriInfo, notificationQueryParams, this.handlersHolder);
        } else if (identifier.contains(RestconfStreamsConstants.NOTIFICATION_STREAM)) {
            response = SubscribeToStreamUtil.notifYangStream(identifier, uriInfo, notificationQueryParams, this.handlersHolder);
        }
        if (response != null) {
            InstanceIdentifierContext<?> iid = SubscribeToStreamUtil.prepareIIDSubsStreamOutput(this.handlersHolder.getSchemaHandler());
            NormalizedNodeAttrBuilder builder = ImmutableLeafNodeBuilder.create().withValue((Object)response.toString());
            builder.withNodeIdentifier((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((String)"subscribe:to:notification", (String)"2016-10-28", (String)"location")));
            HashMap<String, URI> headers = new HashMap<String, URI>();
            headers.put("Location", response);
            return new NormalizedNodeContext(iid, builder.build(), headers);
        }
        String msg = "Bad type of notification of sal-remote";
        LOG.warn("Bad type of notification of sal-remote");
        throw new RestconfDocumentedException("Bad type of notification of sal-remote");
    }

    public static final class NotificationQueryParams {
        private final Instant start;
        private final Instant stop;
        private final String filter;

        private NotificationQueryParams(Instant start, Instant stop, String filter) {
            this.start = start == null ? Instant.now() : start;
            this.stop = stop;
            this.filter = filter;
        }

        static NotificationQueryParams fromUriInfo(UriInfo uriInfo) {
            Instant start = null;
            boolean startTimeUsed = false;
            Instant stop = null;
            boolean stopTimeUsed = false;
            String filter = null;
            boolean filterUsed = false;
            block10: for (Map.Entry entry : uriInfo.getQueryParameters().entrySet()) {
                switch ((String)entry.getKey()) {
                    case "start-time": {
                        if (!startTimeUsed) {
                            startTimeUsed = true;
                            start = SubscribeToStreamUtil.parseDateFromQueryParam(entry);
                            continue block10;
                        }
                        throw new RestconfDocumentedException("Start-time parameter can be used only once.");
                    }
                    case "stop-time": {
                        if (!stopTimeUsed) {
                            stopTimeUsed = true;
                            stop = SubscribeToStreamUtil.parseDateFromQueryParam(entry);
                            continue block10;
                        }
                        throw new RestconfDocumentedException("Stop-time parameter can be used only once.");
                    }
                    case "filter": {
                        if (filterUsed) continue block10;
                        filterUsed = true;
                        filter = (String)((List)entry.getValue()).iterator().next();
                        continue block10;
                    }
                }
                throw new RestconfDocumentedException("Bad parameter used with notifications: " + (String)entry.getKey());
            }
            if (!startTimeUsed && stopTimeUsed) {
                throw new RestconfDocumentedException("Stop-time parameter has to be used with start-time parameter.");
            }
            return new NotificationQueryParams(start, stop, filter);
        }

        @Nonnull
        public Instant getStart() {
            return this.start;
        }

        public Optional<Instant> getStop() {
            return Optional.ofNullable(this.stop);
        }

        public Optional<String> getFilter() {
            return Optional.ofNullable(this.filter);
        }
    }

    public static final class HandlersHolder {
        private final DOMDataBrokerHandler domDataBrokerHandler;
        private final NotificationServiceHandler notificationServiceHandler;
        private final TransactionChainHandler transactionChainHandler;
        private final SchemaContextHandler schemaHandler;

        private HandlersHolder(DOMDataBrokerHandler domDataBrokerHandler, NotificationServiceHandler notificationServiceHandler, TransactionChainHandler transactionChainHandler, SchemaContextHandler schemaHandler) {
            this.domDataBrokerHandler = domDataBrokerHandler;
            this.notificationServiceHandler = notificationServiceHandler;
            this.transactionChainHandler = transactionChainHandler;
            this.schemaHandler = schemaHandler;
        }

        public DOMDataBrokerHandler getDomDataBrokerHandler() {
            return this.domDataBrokerHandler;
        }

        public NotificationServiceHandler getNotificationServiceHandler() {
            return this.notificationServiceHandler;
        }

        public TransactionChainHandler getTransactionChainHandler() {
            return this.transactionChainHandler;
        }

        public SchemaContextHandler getSchemaHandler() {
            return this.schemaHandler;
        }
    }
}

