/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.nb.rfc8040.rests.services.impl;

import com.google.common.base.Preconditions;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMMountPoint;
import org.opendaylight.restconf.common.context.InstanceIdentifierContext;
import org.opendaylight.restconf.common.context.NormalizedNodeContext;
import org.opendaylight.restconf.common.context.WriterParameters;
import org.opendaylight.restconf.common.errors.RestconfDocumentedException;
import org.opendaylight.restconf.common.errors.RestconfError;
import org.opendaylight.restconf.common.patch.PatchContext;
import org.opendaylight.restconf.common.patch.PatchStatusContext;
import org.opendaylight.restconf.nb.rfc8040.handlers.DOMMountPointServiceHandler;
import org.opendaylight.restconf.nb.rfc8040.handlers.SchemaContextHandler;
import org.opendaylight.restconf.nb.rfc8040.handlers.TransactionChainHandler;
import org.opendaylight.restconf.nb.rfc8040.references.SchemaContextRef;
import org.opendaylight.restconf.nb.rfc8040.rests.services.api.RestconfDataService;
import org.opendaylight.restconf.nb.rfc8040.rests.services.api.RestconfStreamsSubscriptionService;
import org.opendaylight.restconf.nb.rfc8040.rests.transactions.TransactionVarsWrapper;
import org.opendaylight.restconf.nb.rfc8040.rests.utils.DeleteDataTransactionUtil;
import org.opendaylight.restconf.nb.rfc8040.rests.utils.PatchDataTransactionUtil;
import org.opendaylight.restconf.nb.rfc8040.rests.utils.PostDataTransactionUtil;
import org.opendaylight.restconf.nb.rfc8040.rests.utils.PutDataTransactionUtil;
import org.opendaylight.restconf.nb.rfc8040.rests.utils.ReadDataTransactionUtil;
import org.opendaylight.restconf.nb.rfc8040.rests.utils.RestconfStreamsConstants;
import org.opendaylight.restconf.nb.rfc8040.utils.parser.ParserIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class RestconfDataServiceImpl
implements RestconfDataService {
    private static final Logger LOG = LoggerFactory.getLogger(RestconfDataServiceImpl.class);
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MMM-dd HH:mm:ss");
    private SchemaContextHandler schemaContextHandler;
    private TransactionChainHandler transactionChainHandler;
    private DOMMountPointServiceHandler mountPointServiceHandler;
    private final RestconfStreamsSubscriptionService delegRestconfSubscrService;

    public RestconfDataServiceImpl(SchemaContextHandler schemaContextHandler, TransactionChainHandler transactionChainHandler, DOMMountPointServiceHandler mountPointServiceHandler, RestconfStreamsSubscriptionService delegRestconfSubscrService) {
        this.schemaContextHandler = Objects.requireNonNull(schemaContextHandler);
        this.transactionChainHandler = Objects.requireNonNull(transactionChainHandler);
        this.mountPointServiceHandler = Objects.requireNonNull(mountPointServiceHandler);
        this.delegRestconfSubscrService = Objects.requireNonNull(delegRestconfSubscrService);
    }

    @Override
    public synchronized void updateHandlers(Object ... handlers) {
        for (Object object : handlers) {
            if (object instanceof SchemaContextHandler) {
                this.schemaContextHandler = (SchemaContextHandler)object;
                continue;
            }
            if (object instanceof DOMMountPointServiceHandler) {
                this.mountPointServiceHandler = (DOMMountPointServiceHandler)object;
                continue;
            }
            if (!(object instanceof TransactionChainHandler)) continue;
            this.transactionChainHandler = (TransactionChainHandler)object;
        }
    }

    @Override
    public Response readData(UriInfo uriInfo) {
        return this.readData(null, uriInfo);
    }

    @Override
    public Response readData(String identifier, UriInfo uriInfo) {
        SchemaContextRef schemaContextRef = new SchemaContextRef(this.schemaContextHandler.get());
        InstanceIdentifierContext<?> instanceIdentifier = ParserIdentifier.toInstanceIdentifier(identifier, schemaContextRef.get(), Optional.of(this.mountPointServiceHandler.get()));
        boolean withDefaUsed = false;
        String withDefa = null;
        block6: for (Map.Entry entry : uriInfo.getQueryParameters().entrySet()) {
            switch ((String)entry.getKey()) {
                case "with-defaults": {
                    if (!withDefaUsed) {
                        withDefaUsed = true;
                        withDefa = (String)((List)entry.getValue()).iterator().next();
                        continue block6;
                    }
                    throw new RestconfDocumentedException("With-defaults parameter can be used only once.");
                }
            }
            LOG.info("Unknown key : {}.", entry.getKey());
        }
        boolean tagged = false;
        if (withDefaUsed) {
            if ("report-all-tagged".equals(withDefa)) {
                tagged = true;
                withDefa = null;
            }
            if ("report-all".equals(withDefa)) {
                withDefa = null;
            }
        }
        WriterParameters parameters = ReadDataTransactionUtil.parseUriParameters(instanceIdentifier, uriInfo, tagged);
        DOMMountPoint mountPoint = instanceIdentifier.getMountPoint();
        TransactionChainHandler localTransactionChainHandler = mountPoint == null ? this.transactionChainHandler : RestconfDataServiceImpl.transactionChainOfMountPoint(mountPoint);
        TransactionVarsWrapper transactionNode = new TransactionVarsWrapper(instanceIdentifier, mountPoint, localTransactionChainHandler);
        NormalizedNode<?, ?> node = ReadDataTransactionUtil.readData(identifier, parameters.getContent(), transactionNode, withDefa, schemaContextRef, uriInfo);
        if (identifier.contains("ietf-restconf-monitoring:restconf-state/streams/stream=") && identifier.contains("/access=") && identifier.contains("/location")) {
            String value = (String)node.getValue();
            String streamName = value.substring(value.indexOf(RestconfStreamsConstants.CREATE_NOTIFICATION_STREAM.toString() + '/'), value.length());
            this.delegRestconfSubscrService.subscribeToStream(streamName, uriInfo);
        }
        if (node == null) {
            throw new RestconfDocumentedException("Request could not be completed because the relevant data model content does not exist", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.DATA_MISSING);
        }
        if (parameters.getContent().equals("all") || parameters.getContent().equals("config")) {
            QName type = node.getNodeType();
            return Response.status((int)200).entity((Object)new NormalizedNodeContext(instanceIdentifier, node, parameters)).header("ETag", (Object)('\"' + (String)type.getModule().getRevision().map(Revision::toString).orElse(null) + type.getLocalName() + '\"')).header("Last-Modified", (Object)FORMATTER.format(LocalDateTime.now(Clock.systemUTC()))).build();
        }
        return Response.status((int)200).entity((Object)new NormalizedNodeContext(instanceIdentifier, node, parameters)).build();
    }

    @Override
    public Response putData(String identifier, NormalizedNodeContext payload, UriInfo uriInfo) {
        SchemaContextRef ref;
        TransactionChainHandler localTransactionChainHandler;
        Preconditions.checkNotNull((Object)payload);
        boolean insertUsed = false;
        boolean pointUsed = false;
        String insert = null;
        String point = null;
        block8: for (Map.Entry entry : uriInfo.getQueryParameters().entrySet()) {
            switch ((String)entry.getKey()) {
                case "insert": {
                    if (!insertUsed) {
                        insertUsed = true;
                        insert = (String)((List)entry.getValue()).iterator().next();
                        continue block8;
                    }
                    throw new RestconfDocumentedException("Insert parameter can be used only once.");
                }
                case "point": {
                    if (!pointUsed) {
                        pointUsed = true;
                        point = (String)((List)entry.getValue()).iterator().next();
                        continue block8;
                    }
                    throw new RestconfDocumentedException("Point parameter can be used only once.");
                }
            }
            throw new RestconfDocumentedException("Bad parameter for post: " + (String)entry.getKey());
        }
        RestconfDataServiceImpl.checkQueryParams(insertUsed, pointUsed, insert);
        InstanceIdentifierContext iid = payload.getInstanceIdentifierContext();
        PutDataTransactionUtil.validInputData(iid.getSchemaNode(), payload);
        PutDataTransactionUtil.validTopLevelNodeName(iid.getInstanceIdentifier(), payload);
        PutDataTransactionUtil.validateListKeysEqualityInPayloadAndUri(payload);
        DOMMountPoint mountPoint = payload.getInstanceIdentifierContext().getMountPoint();
        if (mountPoint == null) {
            localTransactionChainHandler = this.transactionChainHandler;
            ref = new SchemaContextRef(this.schemaContextHandler.get());
        } else {
            localTransactionChainHandler = RestconfDataServiceImpl.transactionChainOfMountPoint(mountPoint);
            ref = new SchemaContextRef(mountPoint.getSchemaContext());
        }
        TransactionVarsWrapper transactionNode = new TransactionVarsWrapper(payload.getInstanceIdentifierContext(), mountPoint, localTransactionChainHandler);
        return PutDataTransactionUtil.putData(payload, ref, transactionNode, insert, point);
    }

    private static void checkQueryParams(boolean insertUsed, boolean pointUsed, String insert) {
        if (pointUsed && !insertUsed) {
            throw new RestconfDocumentedException("Point parameter can't be used without Insert parameter.");
        }
        if (pointUsed && (insert.equals("first") || insert.equals("last"))) {
            throw new RestconfDocumentedException("Point parameter can be used only with 'after' or 'before' values of Insert parameter.");
        }
    }

    @Override
    public Response postData(String identifier, NormalizedNodeContext payload, UriInfo uriInfo) {
        return this.postData(payload, uriInfo);
    }

    @Override
    public Response postData(NormalizedNodeContext payload, UriInfo uriInfo) {
        SchemaContextRef ref;
        TransactionChainHandler localTransactionChainHandler;
        Preconditions.checkNotNull((Object)payload);
        boolean insertUsed = false;
        boolean pointUsed = false;
        String insert = null;
        String point = null;
        block8: for (Map.Entry entry : uriInfo.getQueryParameters().entrySet()) {
            switch ((String)entry.getKey()) {
                case "insert": {
                    if (!insertUsed) {
                        insertUsed = true;
                        insert = (String)((List)entry.getValue()).iterator().next();
                        continue block8;
                    }
                    throw new RestconfDocumentedException("Insert parameter can be used only once.");
                }
                case "point": {
                    if (!pointUsed) {
                        pointUsed = true;
                        point = (String)((List)entry.getValue()).iterator().next();
                        continue block8;
                    }
                    throw new RestconfDocumentedException("Point parameter can be used only once.");
                }
            }
            throw new RestconfDocumentedException("Bad parameter for post: " + (String)entry.getKey());
        }
        RestconfDataServiceImpl.checkQueryParams(insertUsed, pointUsed, insert);
        DOMMountPoint mountPoint = payload.getInstanceIdentifierContext().getMountPoint();
        if (mountPoint == null) {
            localTransactionChainHandler = this.transactionChainHandler;
            ref = new SchemaContextRef(this.schemaContextHandler.get());
        } else {
            localTransactionChainHandler = RestconfDataServiceImpl.transactionChainOfMountPoint(mountPoint);
            ref = new SchemaContextRef(mountPoint.getSchemaContext());
        }
        TransactionVarsWrapper transactionNode = new TransactionVarsWrapper(payload.getInstanceIdentifierContext(), mountPoint, localTransactionChainHandler);
        return PostDataTransactionUtil.postData(uriInfo, payload, transactionNode, ref, insert, point);
    }

    @Override
    public Response deleteData(String identifier) {
        SchemaContextRef schemaContextRef = new SchemaContextRef(this.schemaContextHandler.get());
        InstanceIdentifierContext<?> instanceIdentifier = ParserIdentifier.toInstanceIdentifier(identifier, schemaContextRef.get(), Optional.of(this.mountPointServiceHandler.get()));
        DOMMountPoint mountPoint = instanceIdentifier.getMountPoint();
        TransactionChainHandler localTransactionChainHandler = mountPoint == null ? this.transactionChainHandler : RestconfDataServiceImpl.transactionChainOfMountPoint(mountPoint);
        TransactionVarsWrapper transactionNode = new TransactionVarsWrapper(instanceIdentifier, mountPoint, localTransactionChainHandler);
        return DeleteDataTransactionUtil.deleteData(transactionNode);
    }

    @Override
    public PatchStatusContext patchData(String identifier, PatchContext context, UriInfo uriInfo) {
        return this.patchData(context, uriInfo);
    }

    @Override
    public PatchStatusContext patchData(PatchContext context, UriInfo uriInfo) {
        SchemaContextRef ref;
        TransactionChainHandler localTransactionChainHandler;
        Preconditions.checkNotNull((Object)context);
        DOMMountPoint mountPoint = context.getInstanceIdentifierContext().getMountPoint();
        if (mountPoint == null) {
            localTransactionChainHandler = this.transactionChainHandler;
            ref = new SchemaContextRef(this.schemaContextHandler.get());
        } else {
            localTransactionChainHandler = RestconfDataServiceImpl.transactionChainOfMountPoint(mountPoint);
            ref = new SchemaContextRef(mountPoint.getSchemaContext());
        }
        TransactionVarsWrapper transactionNode = new TransactionVarsWrapper(context.getInstanceIdentifierContext(), mountPoint, localTransactionChainHandler);
        return PatchDataTransactionUtil.patchData(context, transactionNode, ref);
    }

    private static TransactionChainHandler transactionChainOfMountPoint(@Nonnull DOMMountPoint mountPoint) {
        Optional domDataBrokerService = mountPoint.getService(DOMDataBroker.class);
        if (domDataBrokerService.isPresent()) {
            return new TransactionChainHandler((DOMDataBroker)domDataBrokerService.get());
        }
        String errMsg = "DOM data broker service isn't available for mount point " + mountPoint.getIdentifier();
        LOG.warn(errMsg);
        throw new RestconfDocumentedException(errMsg);
    }
}

