/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.nb.rfc8040.references;

import java.lang.ref.SoftReference;
import java.net.URI;
import java.util.Optional;
import java.util.Set;
import org.opendaylight.mdsal.dom.api.DOMMountPoint;
import org.opendaylight.restconf.nb.rfc8040.Rfc8040;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

public final class SchemaContextRef {
    private final SoftReference<SchemaContext> schemaContextRef;

    public SchemaContextRef(SchemaContext schemaContext) {
        this.schemaContextRef = new SoftReference<SchemaContext>(schemaContext);
    }

    public SchemaContext get() {
        return this.schemaContextRef.get();
    }

    public Set<Module> getModules() {
        return this.get().getModules();
    }

    public Set<Module> getModules(DOMMountPoint mountPoint) {
        SchemaContext schemaContext = mountPoint == null ? null : mountPoint.getSchemaContext();
        return schemaContext == null ? null : schemaContext.getModules();
    }

    public Module getRestconfModule() {
        return this.findModuleByNamespaceAndRevision(Rfc8040.RestconfModule.IETF_RESTCONF_QNAME.getNamespace(), Rfc8040.RestconfModule.IETF_RESTCONF_QNAME.getRevision());
    }

    public Module findModuleByNamespaceAndRevision(URI namespace, Optional<Revision> revision) {
        return this.get().findModule(namespace, revision).orElse(null);
    }

    public Module findModuleInMountPointByQName(DOMMountPoint mountPoint, QName moduleQname) {
        SchemaContext schemaContext = mountPoint == null ? null : mountPoint.getSchemaContext();
        return schemaContext == null ? null : (Module)schemaContext.findModule(moduleQname.getLocalName(), moduleQname.getRevision()).orElse(null);
    }

    public Module findModuleByQName(QName moduleQname) {
        return this.findModuleByNameAndRevision(moduleQname.getLocalName(), moduleQname.getRevision());
    }

    public Module findModuleByNameAndRevision(String localName, Optional<Revision> revision) {
        return this.get().findModule(localName, revision).orElse(null);
    }
}

