/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.nb.rfc8040.jersey.providers.patch;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.Provider;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.dom.DOMSource;
import org.opendaylight.restconf.common.context.InstanceIdentifierContext;
import org.opendaylight.restconf.common.errors.RestconfDocumentedException;
import org.opendaylight.restconf.common.errors.RestconfError;
import org.opendaylight.restconf.common.patch.PatchContext;
import org.opendaylight.restconf.common.patch.PatchEditOperation;
import org.opendaylight.restconf.common.patch.PatchEntity;
import org.opendaylight.restconf.nb.rfc8040.codecs.StringModuleInstanceIdentifierCodec;
import org.opendaylight.restconf.nb.rfc8040.handlers.DOMMountPointServiceHandler;
import org.opendaylight.restconf.nb.rfc8040.handlers.SchemaContextHandler;
import org.opendaylight.restconf.nb.rfc8040.jersey.providers.patch.AbstractToPatchBodyReader;
import org.opendaylight.yangtools.util.xml.UntrustedXML;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.XmlParserStream;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizedNodeResult;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.util.SchemaContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Provider
@Consumes(value={"application/yang.patch+xml"})
public class XmlToPatchBodyReader
extends AbstractToPatchBodyReader {
    private static final Logger LOG = LoggerFactory.getLogger(XmlToPatchBodyReader.class);
    private static final Splitter SLASH_SPLITTER = Splitter.on((char)'/');

    public XmlToPatchBodyReader(SchemaContextHandler schemaContextHandler, DOMMountPointServiceHandler mountPointServiceHandler) {
        super(schemaContextHandler, mountPointServiceHandler);
    }

    @Override
    protected PatchContext readBody(InstanceIdentifierContext<?> path, InputStream entityStream) throws WebApplicationException {
        try {
            Document doc = UntrustedXML.newDocumentBuilder().parse(entityStream);
            return XmlToPatchBodyReader.parse(path, doc);
        }
        catch (RestconfDocumentedException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.debug("Error parsing xml input", (Throwable)e);
            throw new RestconfDocumentedException("Error parsing input: " + e.getMessage(), RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.MALFORMED_MESSAGE, (Throwable)e);
        }
    }

    private static PatchContext parse(InstanceIdentifierContext<?> pathContext, Document doc) throws XMLStreamException, IOException, ParserConfigurationException, SAXException, URISyntaxException {
        ArrayList<PatchEntity> resultCollection = new ArrayList<PatchEntity>();
        String patchId = doc.getElementsByTagName("patch-id").item(0).getFirstChild().getNodeValue();
        NodeList editNodes = doc.getElementsByTagName("edit");
        for (int i = 0; i < editNodes.getLength(); ++i) {
            SchemaContext targetNode;
            YangInstanceIdentifier targetII;
            DataSchemaNode schemaNode = (DataSchemaNode)pathContext.getSchemaNode();
            Element element = (Element)editNodes.item(i);
            String operation = element.getElementsByTagName("operation").item(0).getFirstChild().getNodeValue();
            PatchEditOperation oper = PatchEditOperation.valueOf((String)operation.toUpperCase(Locale.ROOT));
            String editId = element.getElementsByTagName("edit-id").item(0).getFirstChild().getNodeValue();
            String target = element.getElementsByTagName("target").item(0).getFirstChild().getNodeValue();
            List<Element> values = XmlToPatchBodyReader.readValueNodes(element, oper);
            Element firstValueElement = values != null ? values.get(0) : null;
            String namespace = firstValueElement == null ? schemaNode.getQName().getNamespace().toString() : firstValueElement.getNamespaceURI();
            Module module = (Module)pathContext.getSchemaContext().findModules(URI.create(namespace)).iterator().next();
            StringModuleInstanceIdentifierCodec codec = new StringModuleInstanceIdentifierCodec(pathContext.getSchemaContext(), module.getName());
            if (target.equals("/")) {
                targetII = pathContext.getInstanceIdentifier();
                targetNode = pathContext.getSchemaContext();
            } else {
                targetII = codec.deserialize(codec.serialize(pathContext.getInstanceIdentifier()).concat(XmlToPatchBodyReader.prepareNonCondXpath(schemaNode, target.replaceFirst("/", ""), firstValueElement, namespace, module.getQNameModule().getRevision().map(Revision::toString).orElse(null))));
                targetNode = SchemaContextUtil.findDataSchemaNode((SchemaContext)pathContext.getSchemaContext(), (SchemaPath)codec.getDataContextTree().getChild(targetII).getDataSchemaNode().getPath().getParent());
                schemaNode = (DataSchemaNode)SchemaContextUtil.findDataSchemaNode((SchemaContext)pathContext.getSchemaContext(), (SchemaPath)codec.getDataContextTree().getChild(targetII).getDataSchemaNode().getPath());
            }
            if (targetNode == null) {
                LOG.debug("Target node {} not found in path {} ", (Object)target, (Object)pathContext.getSchemaNode());
                throw new RestconfDocumentedException("Error parsing input", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.MALFORMED_MESSAGE);
            }
            if (oper.isWithValue()) {
                NormalizedNode parsed;
                if (schemaNode instanceof ContainerSchemaNode || schemaNode instanceof ListSchemaNode) {
                    NormalizedNodeResult resultHolder = new NormalizedNodeResult();
                    NormalizedNodeStreamWriter writer = ImmutableNormalizedNodeStreamWriter.from((NormalizedNodeResult)resultHolder);
                    XmlParserStream xmlParser = XmlParserStream.create((NormalizedNodeStreamWriter)writer, (SchemaContext)pathContext.getSchemaContext(), (SchemaNode)schemaNode);
                    xmlParser.traverse(new DOMSource(firstValueElement));
                    parsed = resultHolder.getResult();
                } else {
                    parsed = null;
                }
                if (targetII.getLastPathArgument() instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates) {
                    targetII = targetII.getParent();
                }
                resultCollection.add(new PatchEntity(editId, oper, targetII, parsed));
                continue;
            }
            resultCollection.add(new PatchEntity(editId, oper, targetII));
        }
        return new PatchContext(pathContext, (List)ImmutableList.copyOf(resultCollection), patchId);
    }

    private static List<Element> readValueNodes(@Nonnull Element element, @Nonnull PatchEditOperation operation) {
        Node valueNode = element.getElementsByTagName("value").item(0);
        if (operation.isWithValue() && valueNode == null) {
            throw new RestconfDocumentedException("Error parsing input", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.MALFORMED_MESSAGE);
        }
        if (!operation.isWithValue() && valueNode != null) {
            throw new RestconfDocumentedException("Error parsing input", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.MALFORMED_MESSAGE);
        }
        if (valueNode == null) {
            return null;
        }
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList childNodes = valueNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            if (!(childNodes.item(i) instanceof Element)) continue;
            result.add((Element)childNodes.item(i));
        }
        return result;
    }

    private static String prepareNonCondXpath(@Nonnull DataSchemaNode schemaNode, @Nonnull String target, @Nonnull Element value, @Nonnull String namespace, @Nonnull String revision) {
        Iterator<String> args = SLASH_SPLITTER.split((CharSequence)target.substring(target.indexOf(58) + 1)).iterator();
        StringBuilder nonCondXpath = new StringBuilder();
        DataSchemaNode childNode = schemaNode;
        while (args.hasNext()) {
            String s = (String)args.next();
            nonCondXpath.append("/");
            nonCondXpath.append(s);
            if (!((childNode = ((DataNodeContainer)childNode).getDataChildByName(QName.create((String)namespace, (String)revision, (String)s))) instanceof ListSchemaNode) || !args.hasNext()) continue;
            XmlToPatchBodyReader.appendKeys(nonCondXpath, ((ListSchemaNode)childNode).getKeyDefinition().iterator(), args);
        }
        if (childNode instanceof ListSchemaNode && value != null) {
            Iterator<String> keyValues = XmlToPatchBodyReader.readKeyValues(value, ((ListSchemaNode)childNode).getKeyDefinition().iterator());
            XmlToPatchBodyReader.appendKeys(nonCondXpath, ((ListSchemaNode)childNode).getKeyDefinition().iterator(), keyValues);
        }
        return nonCondXpath.toString();
    }

    private static Iterator<String> readKeyValues(@Nonnull Element value, @Nonnull Iterator<QName> keys) {
        ArrayList<String> result = new ArrayList<String>();
        while (keys.hasNext()) {
            result.add(value.getElementsByTagName(keys.next().getLocalName()).item(0).getFirstChild().getNodeValue());
        }
        return result.iterator();
    }

    private static void appendKeys(@Nonnull StringBuilder nonCondXpath, @Nonnull Iterator<QName> keyNames, @Nonnull Iterator<String> keyValues) {
        while (keyNames.hasNext()) {
            nonCondXpath.append('[');
            nonCondXpath.append(keyNames.next().getLocalName());
            nonCondXpath.append("='");
            nonCondXpath.append(keyValues.next());
            nonCondXpath.append("']");
        }
    }
}

