/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.nb.rfc8040.jersey.providers;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.opendaylight.restconf.common.context.InstanceIdentifierContext;
import org.opendaylight.restconf.common.context.NormalizedNodeContext;
import org.opendaylight.restconf.nb.rfc8040.jersey.providers.ParameterAwareNormalizedNodeWriter;
import org.opendaylight.restconf.nb.rfc8040.jersey.providers.api.RestconfNormalizedNodeWriter;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactory;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactorySupplier;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.gson.JsonWriterFactory;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

@Provider
@Produces(value={"application/yang-data+json", "application/json"})
public class NormalizedNodeJsonBodyWriter
implements MessageBodyWriter<NormalizedNodeContext> {
    private static final int DEFAULT_INDENT_SPACES_NUM = 2;

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.equals(NormalizedNodeContext.class);
    }

    public long getSize(NormalizedNodeContext context, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(NormalizedNodeContext context, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        NormalizedNode data = context.getData();
        if (data == null) {
            return;
        }
        InstanceIdentifierContext identifierCtx = context.getInstanceIdentifierContext();
        SchemaPath path = identifierCtx.getSchemaNode().getPath();
        try (JsonWriter jsonWriter = NormalizedNodeJsonBodyWriter.createJsonWriter(entityStream, context.getWriterParameters().isPrettyPrint());){
            jsonWriter.beginObject();
            NormalizedNodeJsonBodyWriter.writeNormalizedNode(jsonWriter, path, (InstanceIdentifierContext<SchemaNode>)identifierCtx, data, context.getWriterParameters().getDepth(), context.getWriterParameters().getFields());
            jsonWriter.endObject();
            jsonWriter.flush();
        }
    }

    private static void writeNormalizedNode(JsonWriter jsonWriter, SchemaPath path, InstanceIdentifierContext<SchemaNode> context, NormalizedNode<?, ?> data, Integer depth, List<Set<QName>> fields) throws IOException {
        RestconfNormalizedNodeWriter nnWriter;
        if (context.getSchemaNode() instanceof RpcDefinition) {
            nnWriter = NormalizedNodeJsonBodyWriter.createNormalizedNodeWriter(context, ((RpcDefinition)context.getSchemaNode()).getOutput().getPath(), jsonWriter, depth, fields);
            Module module = (Module)context.getSchemaContext().findModule(data.getNodeType().getModule()).get();
            jsonWriter.name(module.getName() + ":output");
            jsonWriter.beginObject();
            NormalizedNodeJsonBodyWriter.writeChildren(nnWriter, (ContainerNode)data);
            jsonWriter.endObject();
        } else {
            nnWriter = SchemaPath.ROOT.equals((Object)path) ? NormalizedNodeJsonBodyWriter.createNormalizedNodeWriter(context, path, jsonWriter, depth, fields) : NormalizedNodeJsonBodyWriter.createNormalizedNodeWriter(context, path.getParent(), jsonWriter, depth, fields);
            if (data instanceof MapEntryNode) {
                nnWriter.write(ImmutableNodes.mapNodeBuilder((QName)data.getNodeType()).withChild((NormalizedNode)((MapEntryNode)data)).build());
            } else {
                nnWriter.write(data);
            }
        }
        nnWriter.flush();
    }

    private static void writeChildren(RestconfNormalizedNodeWriter nnWriter, ContainerNode data) throws IOException {
        for (DataContainerChild child : data.getValue()) {
            nnWriter.write((NormalizedNode<?, ?>)child);
        }
    }

    private static RestconfNormalizedNodeWriter createNormalizedNodeWriter(InstanceIdentifierContext<SchemaNode> context, SchemaPath path, JsonWriter jsonWriter, Integer depth, List<Set<QName>> fields) {
        SchemaNode schema = context.getSchemaNode();
        JSONCodecFactory codecs = NormalizedNodeJsonBodyWriter.getCodecFactory(context);
        NormalizedNodeStreamWriter streamWriter = JSONNormalizedNodeStreamWriter.createNestedWriter((JSONCodecFactory)codecs, (SchemaPath)path, (URI)NormalizedNodeJsonBodyWriter.initialNamespaceFor(schema, depth), (JsonWriter)jsonWriter);
        return ParameterAwareNormalizedNodeWriter.forStreamWriter(streamWriter, depth, fields);
    }

    private static URI initialNamespaceFor(SchemaNode schema, Integer depth) {
        if (schema instanceof RpcDefinition) {
            return schema.getQName().getNamespace();
        }
        if (depth == null || depth == 0 || schema instanceof SchemaContext) {
            return null;
        }
        return schema instanceof DataSchemaNode && !((DataSchemaNode)schema).isAugmenting() ? schema.getQName().getNamespace() : null;
    }

    private static JsonWriter createJsonWriter(OutputStream entityStream, boolean prettyPrint) {
        if (prettyPrint) {
            return JsonWriterFactory.createJsonWriter((Writer)new OutputStreamWriter(entityStream, StandardCharsets.UTF_8), (int)2);
        }
        return JsonWriterFactory.createJsonWriter((Writer)new OutputStreamWriter(entityStream, StandardCharsets.UTF_8));
    }

    private static JSONCodecFactory getCodecFactory(InstanceIdentifierContext<?> context) {
        return JSONCodecFactorySupplier.RFC7951.getShared(context.getSchemaContext());
    }
}

