/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.nb.rfc8040.handlers;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.common.api.TransactionCommitFailedException;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.restconf.common.errors.RestconfDocumentedException;
import org.opendaylight.restconf.nb.rfc8040.Rfc8040;
import org.opendaylight.restconf.nb.rfc8040.handlers.SchemaContextListenerHandler;
import org.opendaylight.restconf.nb.rfc8040.handlers.TransactionChainHandler;
import org.opendaylight.restconf.nb.rfc8040.utils.mapping.RestconfMappingNodeUtil;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ConflictingModificationAppliedException;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaContextHandler
implements SchemaContextListenerHandler,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaContextHandler.class);
    private final AtomicInteger moduleSetId = new AtomicInteger(0);
    private final TransactionChainHandler transactionChainHandler;
    private final DOMSchemaService domSchemaService;
    private ListenerRegistration<SchemaContextListener> listenerRegistration;
    private volatile SchemaContext schemaContext;

    private SchemaContextHandler(TransactionChainHandler transactionChainHandler, DOMSchemaService domSchemaService) {
        this.transactionChainHandler = transactionChainHandler;
        this.domSchemaService = domSchemaService;
    }

    public static SchemaContextHandler newInstance(TransactionChainHandler transactionChainHandler, DOMSchemaService domSchemaService) {
        return new SchemaContextHandler(transactionChainHandler, domSchemaService);
    }

    public void init() {
        this.listenerRegistration = this.domSchemaService.registerSchemaContextListener((SchemaContextListener)this);
    }

    @Override
    public void close() {
        if (this.listenerRegistration != null) {
            this.listenerRegistration.close();
        }
    }

    public void onGlobalContextUpdated(SchemaContext context) {
        Module monitoringModule;
        Preconditions.checkNotNull((Object)context);
        this.schemaContext = context;
        Module ietfYangLibraryModule = context.findModule(Rfc8040.IetfYangLibrary.MODULE_QNAME).orElse(null);
        if (ietfYangLibraryModule != null) {
            NormalizedNode<YangInstanceIdentifier.NodeIdentifier, Collection<DataContainerChild<? extends YangInstanceIdentifier.PathArgument, ?>>> normNode = RestconfMappingNodeUtil.mapModulesByIetfYangLibraryYang(context.getModules(), ietfYangLibraryModule, context, String.valueOf(this.moduleSetId.incrementAndGet()));
            this.putData(normNode);
        }
        if ((monitoringModule = (Module)this.schemaContext.findModule(Rfc8040.MonitoringModule.MODULE_QNAME).orElse(null)) != null) {
            NormalizedNode<YangInstanceIdentifier.NodeIdentifier, Collection<DataContainerChild<? extends YangInstanceIdentifier.PathArgument, ?>>> normNode = RestconfMappingNodeUtil.mapCapabilites(monitoringModule);
            this.putData(normNode);
        }
    }

    @Override
    public SchemaContext get() {
        return this.schemaContext;
    }

    private void putData(NormalizedNode<YangInstanceIdentifier.NodeIdentifier, Collection<DataContainerChild<? extends YangInstanceIdentifier.PathArgument, ?>>> normNode) {
        DOMDataTreeWriteTransaction wTx = this.transactionChainHandler.get().newWriteOnlyTransaction();
        wTx.put(LogicalDatastoreType.OPERATIONAL, YangInstanceIdentifier.create((YangInstanceIdentifier.PathArgument[])new YangInstanceIdentifier.PathArgument[]{YangInstanceIdentifier.NodeIdentifier.create((QName)normNode.getNodeType())}), normNode);
        try {
            wTx.commit().get();
        }
        catch (InterruptedException e) {
            throw new RestconfDocumentedException("Problem occurred while putting data to DS.", (Throwable)e);
        }
        catch (ExecutionException e) {
            TransactionCommitFailedException failure = (TransactionCommitFailedException)Throwables.getCauseAs((Throwable)e, TransactionCommitFailedException.class);
            if (failure.getCause() instanceof ConflictingModificationAppliedException) {
                LOG.warn("Ignoring that another cluster node is already putting the same data to DS.", (Throwable)e);
                this.transactionChainHandler.reset();
            }
            throw new RestconfDocumentedException("Problem occurred while putting data to DS.", (Throwable)failure);
        }
    }
}

