/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.nb.rfc8040;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.opendaylight.restconf.nb.rfc8040.handlers.DOMMountPointServiceHandler;
import org.opendaylight.restconf.nb.rfc8040.handlers.SchemaContextHandler;
import org.opendaylight.restconf.nb.rfc8040.jersey.providers.JsonNormalizedNodeBodyReader;
import org.opendaylight.restconf.nb.rfc8040.jersey.providers.NormalizedNodeJsonBodyWriter;
import org.opendaylight.restconf.nb.rfc8040.jersey.providers.NormalizedNodeXmlBodyWriter;
import org.opendaylight.restconf.nb.rfc8040.jersey.providers.XmlNormalizedNodeBodyReader;
import org.opendaylight.restconf.nb.rfc8040.jersey.providers.patch.JsonToPatchBodyReader;
import org.opendaylight.restconf.nb.rfc8040.jersey.providers.patch.PatchJsonBodyWriter;
import org.opendaylight.restconf.nb.rfc8040.jersey.providers.patch.PatchXmlBodyWriter;
import org.opendaylight.restconf.nb.rfc8040.jersey.providers.patch.XmlToPatchBodyReader;
import org.opendaylight.restconf.nb.rfc8040.jersey.providers.schema.SchemaExportContentYangBodyWriter;
import org.opendaylight.restconf.nb.rfc8040.jersey.providers.schema.SchemaExportContentYinBodyWriter;
import org.opendaylight.restconf.nb.rfc8040.services.wrapper.ServicesWrapper;

public class RestconfApplication
extends Application {
    private final SchemaContextHandler schemaContextHandler;
    private final DOMMountPointServiceHandler mountPointServiceHandler;
    private final ServicesWrapper servicesWrapper;

    public RestconfApplication(SchemaContextHandler schemaContextHandler, DOMMountPointServiceHandler mountPointServiceHandler, ServicesWrapper servicesWrapper) {
        this.schemaContextHandler = schemaContextHandler;
        this.mountPointServiceHandler = mountPointServiceHandler;
        this.servicesWrapper = servicesWrapper;
    }

    public Set<Class<?>> getClasses() {
        return ImmutableSet.builder().add(NormalizedNodeJsonBodyWriter.class).add(NormalizedNodeXmlBodyWriter.class).add(SchemaExportContentYinBodyWriter.class).add(SchemaExportContentYangBodyWriter.class).add(PatchJsonBodyWriter.class).add(PatchXmlBodyWriter.class).build();
    }

    public Set<Object> getSingletons() {
        HashSet<Object> singletons = new HashSet<Object>();
        singletons.add(this.servicesWrapper);
        singletons.add(new JsonNormalizedNodeBodyReader(this.schemaContextHandler, this.mountPointServiceHandler));
        singletons.add(new JsonToPatchBodyReader(this.schemaContextHandler, this.mountPointServiceHandler));
        singletons.add(new XmlNormalizedNodeBodyReader(this.schemaContextHandler, this.mountPointServiceHandler));
        singletons.add(new XmlToPatchBodyReader(this.schemaContextHandler, this.mountPointServiceHandler));
        return singletons;
    }
}

