/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util.type;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.type.DecimalTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.type.BaseDecimalType;
import org.opendaylight.yangtools.yang.model.util.type.RangeRestrictedTypeBuilder;

public final class DecimalTypeBuilder
extends RangeRestrictedTypeBuilder<DecimalTypeDefinition, BigDecimal> {
    private Integer fractionDigits;

    DecimalTypeBuilder(SchemaPath path) {
        super(null, path);
    }

    public DecimalTypeBuilder setFractionDigits(int fractionDigits) {
        Preconditions.checkState((this.fractionDigits == null ? 1 : 0) != 0, (String)"Fraction digits already defined to %s", (Object)this.fractionDigits);
        this.fractionDigits = fractionDigits;
        return this;
    }

    @Override
    DecimalTypeDefinition buildType() {
        Preconditions.checkState((this.fractionDigits != null ? 1 : 0) != 0, (Object)"Fraction digits not defined");
        return new BaseDecimalType(this.getPath(), this.getUnknownSchemaNodes(), this.fractionDigits, this.calculateRangeConstraint(BaseDecimalType.constraintsForDigits(this.fractionDigits)));
    }
}

