/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util.type;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;

final class BitImpl
implements BitsTypeDefinition.Bit,
Immutable {
    private final @NonNull ImmutableList<UnknownSchemaNode> unknownNodes;
    private final @NonNull SchemaPath schemaPath;
    private final String description;
    private final String reference;
    private final @NonNull Status status;
    private final long position;

    BitImpl(SchemaPath schemaPath, long position, String description, String reference, Status status, List<UnknownSchemaNode> unknownNodes) {
        this.schemaPath = Objects.requireNonNull(schemaPath, "Schema Path should not be null");
        Preconditions.checkArgument((position >= 0L && position <= 0xFFFFFFFFL ? 1 : 0) != 0, (String)"Invalid position %s", (long)position);
        this.position = position;
        this.description = description;
        this.reference = reference;
        this.status = Objects.requireNonNull(status);
        this.unknownNodes = ImmutableList.copyOf(unknownNodes);
    }

    public QName getQName() {
        return this.schemaPath.getLastComponent();
    }

    public SchemaPath getPath() {
        return this.schemaPath;
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public Optional<String> getReference() {
        return Optional.ofNullable(this.reference);
    }

    public Status getStatus() {
        return this.status;
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return this.unknownNodes;
    }

    public long getPosition() {
        return this.position;
    }

    public String getName() {
        return this.getQName().getLocalName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getQName().hashCode();
        result = 31 * result + this.schemaPath.hashCode();
        result = 31 * result + Long.hashCode(this.position);
        result = 31 * result + this.unknownNodes.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BitsTypeDefinition.Bit other = (BitsTypeDefinition.Bit)obj;
        return Objects.equals(this.schemaPath, other.getPath());
    }

    public String toString() {
        return BitsTypeDefinition.Bit.class.getSimpleName() + "[name=" + this.getQName().getLocalName() + ", position=" + this.position + "]";
    }
}

