/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util.type;

import com.google.common.annotations.Beta;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BinaryTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BooleanTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EmptyTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.InstanceIdentifierTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int8TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.StringTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint8TypeDefinition;
import org.opendaylight.yangtools.yang.model.util.type.BaseBinaryType;
import org.opendaylight.yangtools.yang.model.util.type.BaseBooleanType;
import org.opendaylight.yangtools.yang.model.util.type.BaseEmptyType;
import org.opendaylight.yangtools.yang.model.util.type.BaseInstanceIdentifierType;
import org.opendaylight.yangtools.yang.model.util.type.BaseInt16Type;
import org.opendaylight.yangtools.yang.model.util.type.BaseInt32Type;
import org.opendaylight.yangtools.yang.model.util.type.BaseInt64Type;
import org.opendaylight.yangtools.yang.model.util.type.BaseInt8Type;
import org.opendaylight.yangtools.yang.model.util.type.BaseStringType;
import org.opendaylight.yangtools.yang.model.util.type.BaseUint16Type;
import org.opendaylight.yangtools.yang.model.util.type.BaseUint32Type;
import org.opendaylight.yangtools.yang.model.util.type.BaseUint64Type;
import org.opendaylight.yangtools.yang.model.util.type.BaseUint8Type;
import org.opendaylight.yangtools.yang.model.util.type.BitsTypeBuilder;
import org.opendaylight.yangtools.yang.model.util.type.DecimalTypeBuilder;
import org.opendaylight.yangtools.yang.model.util.type.EnumerationTypeBuilder;
import org.opendaylight.yangtools.yang.model.util.type.IdentityrefTypeBuilder;
import org.opendaylight.yangtools.yang.model.util.type.LeafrefTypeBuilder;
import org.opendaylight.yangtools.yang.model.util.type.UnionTypeBuilder;

@Beta
public final class BaseTypes {
    private BaseTypes() {
        throw new UnsupportedOperationException();
    }

    public static @NonNull BinaryTypeDefinition binaryType() {
        return BaseBinaryType.INSTANCE;
    }

    public static @NonNull BitsTypeBuilder bitsTypeBuilder(SchemaPath path) {
        return new BitsTypeBuilder(path);
    }

    public static @NonNull BooleanTypeDefinition booleanType() {
        return BaseBooleanType.INSTANCE;
    }

    public static @NonNull DecimalTypeBuilder decimalTypeBuilder(SchemaPath path) {
        return new DecimalTypeBuilder(path);
    }

    public static @NonNull EmptyTypeDefinition emptyType() {
        return BaseEmptyType.INSTANCE;
    }

    public static @NonNull EnumerationTypeBuilder enumerationTypeBuilder(SchemaPath path) {
        return new EnumerationTypeBuilder(path);
    }

    public static @NonNull IdentityrefTypeBuilder identityrefTypeBuilder(SchemaPath path) {
        return new IdentityrefTypeBuilder(path);
    }

    public static @NonNull InstanceIdentifierTypeDefinition instanceIdentifierType() {
        return BaseInstanceIdentifierType.INSTANCE;
    }

    public static @NonNull Int8TypeDefinition int8Type() {
        return BaseInt8Type.INSTANCE;
    }

    public static boolean isInt8(TypeDefinition<?> type) {
        return BaseInt8Type.INSTANCE.getPath().equals((Object)type.getPath());
    }

    public static @NonNull Int16TypeDefinition int16Type() {
        return BaseInt16Type.INSTANCE;
    }

    public static boolean isInt16(TypeDefinition<?> type) {
        return BaseInt16Type.INSTANCE.getPath().equals((Object)type.getPath());
    }

    public static @NonNull Int32TypeDefinition int32Type() {
        return BaseInt32Type.INSTANCE;
    }

    public static boolean isInt32(TypeDefinition<?> type) {
        return BaseInt32Type.INSTANCE.getPath().equals((Object)type.getPath());
    }

    public static @NonNull Int64TypeDefinition int64Type() {
        return BaseInt64Type.INSTANCE;
    }

    public static boolean isInt64(TypeDefinition<?> type) {
        return BaseInt64Type.INSTANCE.getPath().equals((Object)type.getPath());
    }

    public static @NonNull LeafrefTypeBuilder leafrefTypeBuilder(SchemaPath path) {
        return new LeafrefTypeBuilder(path);
    }

    public static @NonNull StringTypeDefinition stringType() {
        return BaseStringType.INSTANCE;
    }

    public static UnionTypeBuilder unionTypeBuilder(SchemaPath path) {
        return new UnionTypeBuilder(path);
    }

    public static @NonNull Uint8TypeDefinition uint8Type() {
        return BaseUint8Type.INSTANCE;
    }

    public static boolean isUint8(@NonNull TypeDefinition<?> type) {
        return BaseUint8Type.INSTANCE.getPath().equals((Object)type.getPath());
    }

    public static @NonNull Uint16TypeDefinition uint16Type() {
        return BaseUint16Type.INSTANCE;
    }

    public static boolean isUint16(@NonNull TypeDefinition<?> type) {
        return BaseUint16Type.INSTANCE.getPath().equals((Object)type.getPath());
    }

    public static @NonNull Uint32TypeDefinition uint32Type() {
        return BaseUint32Type.INSTANCE;
    }

    public static boolean isUint32(@NonNull TypeDefinition<?> type) {
        return BaseUint32Type.INSTANCE.getPath().equals((Object)type.getPath());
    }

    public static @NonNull Uint64TypeDefinition uint64Type() {
        return BaseUint64Type.INSTANCE;
    }

    public static boolean isUint64(@NonNull TypeDefinition<?> type) {
        return BaseUint64Type.INSTANCE.getPath().equals((Object)type.getPath());
    }

    public static @NonNull TypeDefinition<?> baseTypeOf(@NonNull TypeDefinition<?> type) {
        TypeDefinition ret = type;
        while (ret.getBaseType() != null) {
            ret = ret.getBaseType();
        }
        return ret;
    }
}

