/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util.type;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.util.type.AbstractBaseType;
import org.opendaylight.yangtools.yang.model.util.type.AbstractDerivedType;
import org.opendaylight.yangtools.yang.model.util.type.TypeBuilder;

abstract class AbstractRestrictedTypeBuilder<T extends TypeDefinition<T>>
extends TypeBuilder<T> {
    private boolean touched;

    AbstractRestrictedTypeBuilder(T baseType, SchemaPath path) {
        super(baseType, path);
        if (baseType != null) {
            Preconditions.checkArgument((baseType instanceof AbstractBaseType || baseType instanceof AbstractDerivedType ? 1 : 0) != 0, (String)"Restricted type has to be based on either a base or derived type, not %s", baseType);
        } else {
            this.touched = true;
        }
    }

    final void touch() {
        this.touched = true;
    }

    abstract @NonNull T buildType();

    public final T build() {
        return (T)(this.touched ? this.buildType() : (TypeDefinition)Verify.verifyNotNull(this.getBaseType()));
    }
}

