/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DerivableSchemaNode;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;

public final class SchemaNodeUtils {
    private SchemaNodeUtils() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static Optional<SchemaNode> getOriginalIfPossible(SchemaNode node) {
        if (node instanceof DerivableSchemaNode) {
            Optional ret = ((DerivableSchemaNode)node).getOriginal();
            return ret;
        }
        return Optional.empty();
    }

    public static SchemaNode getRootOriginalIfPossible(SchemaNode data) {
        Optional<Object> previous = Optional.empty();
        Optional<SchemaNode> next = SchemaNodeUtils.getOriginalIfPossible(data);
        while (next.isPresent()) {
            previous = next;
            next = SchemaNodeUtils.getOriginalIfPossible(next.get());
        }
        return previous.orElse(null);
    }

    public static @Nullable ContainerSchemaNode getRpcDataSchema(@NonNull RpcDefinition rpc, @NonNull QName qname) {
        Objects.requireNonNull(rpc, "Rpc Schema must not be null");
        switch (Objects.requireNonNull(qname, "QName must not be null").getLocalName()) {
            case "input": {
                return rpc.getInput();
            }
            case "output": {
                return rpc.getOutput();
            }
        }
        throw new IllegalArgumentException("Supplied qname " + qname + " does not represent rpc input or output.");
    }
}

