/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.model.api.type.ModifierKind;
import org.opendaylight.yangtools.yang.model.api.type.PatternConstraint;

final class PatternConstraintImpl
implements PatternConstraint,
Immutable {
    private final String regex;
    private final String description;
    private final String reference;
    private final String errorAppTag;
    private final String errorMessage;
    private final ModifierKind modifier;

    PatternConstraintImpl(String regex, Optional<String> description, Optional<String> reference) {
        this(regex, description, reference, null, null, Optional.empty());
    }

    PatternConstraintImpl(String regex, Optional<String> description, Optional<String> reference, String errorAppTag, String errorMessage, Optional<ModifierKind> modifier) {
        this.regex = Objects.requireNonNull(regex, "regex must not be null.");
        this.description = description.orElse(null);
        this.reference = reference.orElse(null);
        this.errorAppTag = errorAppTag != null ? errorAppTag : "invalid-regular-expression";
        this.errorMessage = errorMessage;
        this.modifier = modifier.orElse(null);
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public Optional<String> getErrorAppTag() {
        return Optional.ofNullable(this.errorAppTag);
    }

    public Optional<String> getErrorMessage() {
        return Optional.ofNullable(this.errorMessage);
    }

    public Optional<String> getReference() {
        return Optional.ofNullable(this.reference);
    }

    public String getJavaPatternString() {
        return this.regex;
    }

    public String getRegularExpressionString() {
        throw new UnsupportedOperationException();
    }

    public Optional<ModifierKind> getModifier() {
        return Optional.ofNullable(this.modifier);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.errorAppTag, this.errorMessage, this.reference, this.regex, this.modifier);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PatternConstraintImpl)) {
            return false;
        }
        PatternConstraintImpl other = (PatternConstraintImpl)obj;
        return Objects.equals(this.description, other.description) && Objects.equals(this.errorAppTag, other.errorAppTag) && Objects.equals(this.errorMessage, other.errorMessage) && Objects.equals(this.reference, other.reference) && Objects.equals(this.regex, other.regex) && Objects.equals(this.modifier, other.modifier);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("regex", (Object)this.regex).add("description", (Object)this.description).add("reference", (Object)this.reference).add("errorAppTag", (Object)this.errorAppTag).add("errorMessage", (Object)this.errorMessage).add("modifier", (Object)this.modifier).toString();
    }
}

