/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.repo.util;

import com.google.common.annotations.Beta;
import com.google.common.base.FinalizablePhantomReference;
import com.google.common.base.FinalizableReferenceQueue;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.FluentFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.opendaylight.yangtools.util.concurrent.FluentFutures;
import org.opendaylight.yangtools.yang.model.repo.api.MissingSchemaSourceException;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceRepresentation;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.spi.PotentialSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceRegistration;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceRegistry;
import org.opendaylight.yangtools.yang.model.repo.util.AbstractSchemaSourceCache;

@Beta
public class InMemorySchemaSourceCache<T extends SchemaSourceRepresentation>
extends AbstractSchemaSourceCache<T>
implements AutoCloseable {
    private final List<FinalizablePhantomReference<T>> regs = Collections.synchronizedList(new ArrayList());
    private final FinalizableReferenceQueue queue = new FinalizableReferenceQueue();
    private final Cache<SourceIdentifier, T> cache;

    protected InMemorySchemaSourceCache(SchemaSourceRegistry consumer, Class<T> representation, CacheBuilder<Object, Object> builder) {
        super(consumer, representation, PotentialSchemaSource.Costs.IMMEDIATE);
        this.cache = builder.build();
    }

    public static <R extends SchemaSourceRepresentation> InMemorySchemaSourceCache<R> createSoftCache(SchemaSourceRegistry consumer, Class<R> representation) {
        return new InMemorySchemaSourceCache<R>(consumer, representation, (CacheBuilder<Object, Object>)CacheBuilder.newBuilder().softValues());
    }

    public static <R extends SchemaSourceRepresentation> InMemorySchemaSourceCache<R> createSoftCache(SchemaSourceRegistry consumer, Class<R> representation, long lifetime, TimeUnit units) {
        return new InMemorySchemaSourceCache<R>(consumer, representation, (CacheBuilder<Object, Object>)CacheBuilder.newBuilder().softValues().expireAfterAccess(lifetime, units));
    }

    public FluentFuture<? extends T> getSource(SourceIdentifier sourceIdentifier) {
        SchemaSourceRepresentation present = (SchemaSourceRepresentation)this.cache.getIfPresent((Object)sourceIdentifier);
        return present != null ? FluentFutures.immediateFluentFuture((Object)present) : FluentFutures.immediateFailedFluentFuture((Throwable)new MissingSchemaSourceException("Source not found", sourceIdentifier));
    }

    @Override
    protected void offer(T source) {
        SchemaSourceRepresentation present = (SchemaSourceRepresentation)this.cache.getIfPresent((Object)source.getIdentifier());
        if (present == null) {
            this.cache.put((Object)source.getIdentifier(), source);
            final SchemaSourceRegistration reg = this.register(source.getIdentifier());
            FinalizablePhantomReference ref = new FinalizablePhantomReference<T>((SchemaSourceRepresentation)source, this.queue){

                public void finalizeReferent() {
                    reg.close();
                    InMemorySchemaSourceCache.this.regs.remove((Object)this);
                }
            };
            this.regs.add(ref);
        }
    }

    @Override
    public void close() {
        while (!this.regs.isEmpty()) {
            FinalizablePhantomReference<T> ref = this.regs.get(0);
            ref.finalizeReferent();
        }
        this.cache.invalidateAll();
        this.queue.close();
    }
}

