/*
 * Decompiled with CFR 0.152.
 */
package javax.ejb.embeddable;

import java.util.Collections;
import java.util.Map;
import javax.ejb.EJBException;
import javax.ejb.spi.EJBContainerProvider;
import javax.naming.Context;
import org.apache.geronimo.osgi.locator.ProviderLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EJBContainer {
    public static final String PROVIDER = "javax.ejb.embeddable.provider";
    public static final String APP_NAME = "javax.ejb.embeddable.appName";
    public static final String MODULES = "javax.ejb.embeddable.modules";

    public abstract void close();

    public static EJBContainer createEJBContainer() {
        return EJBContainer.createEJBContainer(Collections.EMPTY_MAP);
    }

    public static EJBContainer createEJBContainer(Map<?, ?> properties) {
        Object o;
        if (properties == null) {
            properties = Collections.EMPTY_MAP;
        }
        if ((o = properties.get(PROVIDER)) instanceof String) {
            Class<?> providerClass;
            String providerName = (String)o;
            try {
                providerClass = ProviderLocator.loadClass(providerName);
            }
            catch (Exception e) {
                throw new EJBException("Invalid or inaccessible provider class: " + providerName, e);
            }
            try {
                EJBContainerProvider provider = (EJBContainerProvider)providerClass.newInstance();
                return provider.createEJBContainer(properties);
            }
            catch (Exception e) {
                throw new EJBException("Provider error. Provider: " + providerName, e);
            }
        }
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            EJBContainerProvider provider = (EJBContainerProvider)ProviderLocator.getService(EJBContainerProvider.class.getName(), EJBContainer.class, loader);
            if (provider != null) {
                return provider.createEJBContainer(properties);
            }
            throw new EJBException("Provider error. No provider definition found");
        }
        catch (Exception e) {
            throw new EJBException("Provider error. No provider found", e);
        }
    }

    public abstract Context getContext();
}

