/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.config;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.deltaspike.core.api.config.PropertyFileConfig;
import org.apache.deltaspike.core.impl.config.EnvironmentPropertyConfigSource;
import org.apache.deltaspike.core.impl.config.EnvironmentPropertyConfigSourceProvider;
import org.apache.deltaspike.core.impl.config.LocalJndiConfigSource;
import org.apache.deltaspike.core.impl.config.PropertyFileConfigSource;
import org.apache.deltaspike.core.impl.config.SystemPropertyConfigSource;
import org.apache.deltaspike.core.spi.config.ConfigSource;
import org.apache.deltaspike.core.spi.config.ConfigSourceProvider;
import org.apache.deltaspike.core.util.ServiceUtils;

public class DefaultConfigSourceProvider
implements ConfigSourceProvider {
    private static final Logger LOG = Logger.getLogger(DefaultConfigSourceProvider.class.getName());
    private static final String PROPERTY_FILE_NAME = "apache-deltaspike.properties";
    private static final String PROPERTY_FILE_RESOURCE = "META-INF/apache-deltaspike.properties";
    private static final String PROPERTY_FILE_HOME_NAME = "/.deltaspike/apache-deltaspike.properties";
    private List<ConfigSource> configSources = new ArrayList<ConfigSource>();

    public DefaultConfigSourceProvider() {
        this.configSources.add(new SystemPropertyConfigSource());
        this.configSources.add(new EnvironmentPropertyConfigSource());
        this.configSources.add(new LocalJndiConfigSource());
        this.addUserHomeConfigSource();
        EnvironmentPropertyConfigSourceProvider epcsp = new EnvironmentPropertyConfigSourceProvider(PROPERTY_FILE_RESOURCE, true);
        this.configSources.addAll(epcsp.getConfigSources());
        this.registerPropertyFileConfigs();
    }

    private void addUserHomeConfigSource() {
        File dsHome;
        String userHome = System.getProperty("user.home");
        if (userHome != null && !userHome.isEmpty() && (dsHome = new File(userHome, PROPERTY_FILE_HOME_NAME)).exists()) {
            try {
                PropertyFileConfigSource dsHomeConfigSource = new PropertyFileConfigSource(dsHome.toURI().toURL());
                this.configSources.add(dsHomeConfigSource);
                LOG.log(Level.INFO, "Reading configuration from {}", dsHome.getAbsolutePath());
            }
            catch (MalformedURLException e) {
                LOG.log(Level.WARNING, "Could not read configuration from " + dsHome.getAbsolutePath(), e);
            }
        }
    }

    private void registerPropertyFileConfigs() {
        List propertyFileConfigs = ServiceUtils.loadServiceImplementations(PropertyFileConfig.class);
        for (PropertyFileConfig propertyFileConfig : propertyFileConfigs) {
            EnvironmentPropertyConfigSourceProvider environmentPropertyConfigSourceProvider = new EnvironmentPropertyConfigSourceProvider(propertyFileConfig.getPropertyFileName(), propertyFileConfig.isOptional());
            this.configSources.addAll(environmentPropertyConfigSourceProvider.getConfigSources());
        }
    }

    public List<ConfigSource> getConfigSources() {
        return this.configSources;
    }
}

