/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.sshd.common.BuiltinFactory;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.cipher.BuiltinCiphers;
import org.apache.sshd.common.compression.BuiltinCompressions;
import org.apache.sshd.common.compression.Compression;
import org.apache.sshd.common.compression.CompressionFactory;
import org.apache.sshd.common.config.CompressionConfigValue;
import org.apache.sshd.common.config.ConfigFileReaderSupport;
import org.apache.sshd.common.helpers.AbstractFactoryManager;
import org.apache.sshd.common.kex.BuiltinDHFactories;
import org.apache.sshd.common.kex.DHFactory;
import org.apache.sshd.common.kex.KeyExchange;
import org.apache.sshd.common.mac.BuiltinMacs;
import org.apache.sshd.common.signature.BuiltinSignatures;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public final class SshConfigFileReader {
    private SshConfigFileReader() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    public static BuiltinCiphers.ParseResult getCiphers(PropertyResolver props) {
        return BuiltinCiphers.parseCiphersList(props == null ? null : props.getString("Ciphers"));
    }

    public static BuiltinMacs.ParseResult getMacs(PropertyResolver props) {
        return BuiltinMacs.parseMacsList(props == null ? null : props.getString("MACs"));
    }

    public static BuiltinSignatures.ParseResult getSignatures(PropertyResolver props) {
        return BuiltinSignatures.parseSignatureList(props == null ? null : props.getString("HostKeyAlgorithms"));
    }

    public static BuiltinDHFactories.ParseResult getKexFactories(PropertyResolver props) {
        return BuiltinDHFactories.parseDHFactoriesList(props == null ? null : props.getString("KexAlgorithms"));
    }

    public static CompressionFactory getCompression(PropertyResolver props) {
        return CompressionConfigValue.fromName(props == null ? null : props.getString("Compression"));
    }

    public static <M extends AbstractFactoryManager> M configure(M manager, PropertyResolver props, boolean lenient, boolean ignoreUnsupported) {
        SshConfigFileReader.configureCiphers(manager, props, lenient, ignoreUnsupported);
        SshConfigFileReader.configureSignatures(manager, props, lenient, ignoreUnsupported);
        SshConfigFileReader.configureMacs(manager, props, lenient, ignoreUnsupported);
        SshConfigFileReader.configureCompression(manager, props, lenient, ignoreUnsupported);
        return manager;
    }

    public static <M extends AbstractFactoryManager> M configureCiphers(M manager, PropertyResolver props, boolean lenient, boolean ignoreUnsupported) {
        Objects.requireNonNull(props, "No properties to configure");
        return SshConfigFileReader.configureCiphers(manager, props.getStringProperty("Ciphers", "aes128-ctr,aes192-ctr,aes256-ctr"), lenient, ignoreUnsupported);
    }

    public static <M extends AbstractFactoryManager> M configureCiphers(M manager, String value, boolean lenient, boolean ignoreUnsupported) {
        Objects.requireNonNull(manager, "No manager to configure");
        BuiltinCiphers.ParseResult result = BuiltinCiphers.parseCiphersList(value);
        List<String> unsupported = result.getUnsupportedFactories();
        ValidateUtils.checkTrue(lenient || GenericUtils.isEmpty(unsupported), "Unsupported cipher(s) (%s) in %s", unsupported, value);
        List factories = BuiltinFactory.setUpFactories(ignoreUnsupported, result.getParsedFactories());
        manager.setCipherFactories(ValidateUtils.checkNotNullAndNotEmpty(factories, "No known/unsupported ciphers(s): %s", value));
        return manager;
    }

    public static <M extends AbstractFactoryManager> M configureSignatures(M manager, PropertyResolver props, boolean lenient, boolean ignoreUnsupported) {
        Objects.requireNonNull(props, "No properties to configure");
        return SshConfigFileReader.configureSignatures(manager, props.getStringProperty("HostKeyAlgorithms", "ssh-rsa,ssh-dss"), lenient, ignoreUnsupported);
    }

    public static <M extends AbstractFactoryManager> M configureSignatures(M manager, String value, boolean lenient, boolean ignoreUnsupported) {
        Objects.requireNonNull(manager, "No manager to configure");
        BuiltinSignatures.ParseResult result = BuiltinSignatures.parseSignatureList(value);
        List<String> unsupported = result.getUnsupportedFactories();
        ValidateUtils.checkTrue(lenient || GenericUtils.isEmpty(unsupported), "Unsupported signatures (%s) in %s", unsupported, value);
        List factories = BuiltinFactory.setUpFactories(ignoreUnsupported, result.getParsedFactories());
        manager.setSignatureFactories(ValidateUtils.checkNotNullAndNotEmpty(factories, "No known/supported signatures: %s", value));
        return manager;
    }

    public static <M extends AbstractFactoryManager> M configureMacs(M manager, PropertyResolver resolver, boolean lenient, boolean ignoreUnsupported) {
        Objects.requireNonNull(resolver, "No properties to configure");
        return SshConfigFileReader.configureMacs(manager, resolver.getStringProperty("MACs", "hmac-md5,hmac-sha1,umac-64@openssh.com,hmac-ripemd160,hmac-sha1-96,hmac-md5-96,hmac-sha2-256,hmac-sha2-256-96,hmac-sha2-512,hmac-sha2-512-96"), lenient, ignoreUnsupported);
    }

    public static <M extends AbstractFactoryManager> M configureMacs(M manager, String value, boolean lenient, boolean ignoreUnsupported) {
        Objects.requireNonNull(manager, "No manager to configure");
        BuiltinMacs.ParseResult result = BuiltinMacs.parseMacsList(value);
        List<String> unsupported = result.getUnsupportedFactories();
        ValidateUtils.checkTrue(lenient || GenericUtils.isEmpty(unsupported), "Unsupported MAC(s) (%s) in %s", unsupported, value);
        List factories = BuiltinFactory.setUpFactories(ignoreUnsupported, result.getParsedFactories());
        manager.setMacFactories(ValidateUtils.checkNotNullAndNotEmpty(factories, "No known/supported MAC(s): %s", value));
        return manager;
    }

    public static <M extends AbstractFactoryManager> M configureKeyExchanges(M manager, PropertyResolver props, boolean lenient, Function<? super DHFactory, ? extends NamedFactory<KeyExchange>> xformer, boolean ignoreUnsupported) {
        Objects.requireNonNull(props, "No properties to configure");
        return SshConfigFileReader.configureKeyExchanges(manager, props.getStringProperty("KexAlgorithms", "ecdh-sha2-nistp256,ecdh-sha2-nistp384,ecdh-sha2-nistp521,diffie-hellman-group-exchange-sha256,diffie-hellman-group-exchange-sha1,diffie-hellman-group18-sha512,diffie-hellman-group17-sha512,diffie-hellman-group16-sha512,diffie-hellman-group15-sha512,diffie-hellman-group14-sha256,diffie-hellman-group14-sha1,diffie-hellman-group1-sha1"), lenient, xformer, ignoreUnsupported);
    }

    public static <M extends AbstractFactoryManager> M configureKeyExchanges(M manager, String value, boolean lenient, Function<? super DHFactory, ? extends NamedFactory<KeyExchange>> xformer, boolean ignoreUnsupported) {
        Objects.requireNonNull(manager, "No manager to configure");
        Objects.requireNonNull(xformer, "No DHFactory transformer");
        BuiltinDHFactories.ParseResult result = BuiltinDHFactories.parseDHFactoriesList(value);
        List<String> unsupported = result.getUnsupportedFactories();
        ValidateUtils.checkTrue(lenient || GenericUtils.isEmpty(unsupported), "Unsupported KEX(s) (%s) in %s", unsupported, value);
        List factories = NamedFactory.setUpTransformedFactories(ignoreUnsupported, result.getParsedFactories(), xformer);
        manager.setKeyExchangeFactories(ValidateUtils.checkNotNullAndNotEmpty(factories, "No known/supported KEXS(s): %s", value));
        return manager;
    }

    public static <M extends AbstractFactoryManager> M configureCompression(M manager, PropertyResolver props, boolean lenient, boolean ignoreUnsupported) {
        Objects.requireNonNull(manager, "No manager to configure");
        Objects.requireNonNull(props, "No properties to configure");
        String value = props.getStringProperty("Compression", ConfigFileReaderSupport.DEFAULT_COMPRESSION);
        CompressionConfigValue factory = CompressionConfigValue.fromName(value);
        ValidateUtils.checkTrue(lenient || factory != null, "Unsupported compression value: %s", (Object)value);
        if (factory != null && factory.isSupported()) {
            manager.setCompressionFactories(Collections.singletonList(factory));
        }
        return manager;
    }

    public static <M extends AbstractFactoryManager> M configureCompression(M manager, String value, boolean lenient, boolean ignoreUnsupported) {
        Objects.requireNonNull(manager, "No manager to configure");
        CompressionConfigValue factory = CompressionConfigValue.fromName(value);
        if (factory != null) {
            if (ignoreUnsupported || factory.isSupported()) {
                manager.setCompressionFactories(Collections.singletonList(factory));
            }
        } else {
            BuiltinCompressions.ParseResult result = BuiltinCompressions.parseCompressionsList(value);
            List<String> unsupported = result.getUnsupportedFactories();
            ValidateUtils.checkTrue(lenient || GenericUtils.isEmpty(unsupported), "Unsupported compressions(s) (%s) in %s", unsupported, value);
            List<NamedFactory<Compression>> factories = BuiltinFactory.setUpFactories(ignoreUnsupported, result.getParsedFactories());
            if (GenericUtils.size(factories) > 0) {
                manager.setCompressionFactories(factories);
            }
        }
        return manager;
    }
}

