/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.RestockToasterInput;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class RestockToasterInputBuilder
implements Builder<RestockToasterInput> {
    private Long _amountOfBreadToStock;
    Map<Class<? extends Augmentation<RestockToasterInput>>, Augmentation<RestockToasterInput>> augmentation = Collections.emptyMap();

    public RestockToasterInputBuilder() {
    }

    public RestockToasterInputBuilder(RestockToasterInput base) {
        Map aug;
        this._amountOfBreadToStock = base.getAmountOfBreadToStock();
        if (base instanceof RestockToasterInputImpl) {
            RestockToasterInputImpl impl = (RestockToasterInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<RestockToasterInput>>, Augmentation<RestockToasterInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<RestockToasterInput>>, Augmentation<RestockToasterInput>>(aug);
        }
    }

    public Long getAmountOfBreadToStock() {
        return this._amountOfBreadToStock;
    }

    public <E$$ extends Augmentation<RestockToasterInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    private static void checkAmountOfBreadToStockRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (long)value);
    }

    public RestockToasterInputBuilder setAmountOfBreadToStock(Long value) {
        if (value != null) {
            RestockToasterInputBuilder.checkAmountOfBreadToStockRange(value);
        }
        this._amountOfBreadToStock = value;
        return this;
    }

    public RestockToasterInputBuilder addAugmentation(Class<? extends Augmentation<RestockToasterInput>> augmentationType, Augmentation<RestockToasterInput> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<RestockToasterInput>>, Augmentation<RestockToasterInput>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public RestockToasterInputBuilder removeAugmentation(Class<? extends Augmentation<RestockToasterInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public RestockToasterInput build() {
        return new RestockToasterInputImpl(this);
    }

    private static final class RestockToasterInputImpl
    implements RestockToasterInput {
        private final Long _amountOfBreadToStock;
        private Map<Class<? extends Augmentation<RestockToasterInput>>, Augmentation<RestockToasterInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        RestockToasterInputImpl(RestockToasterInputBuilder base) {
            this._amountOfBreadToStock = base.getAmountOfBreadToStock();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<RestockToasterInput> getImplementedInterface() {
            return RestockToasterInput.class;
        }

        @Override
        public Long getAmountOfBreadToStock() {
            return this._amountOfBreadToStock;
        }

        public <E$$ extends Augmentation<RestockToasterInput>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._amountOfBreadToStock);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!RestockToasterInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            RestockToasterInput other = (RestockToasterInput)obj;
            if (!Objects.equals(this._amountOfBreadToStock, other.getAmountOfBreadToStock())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                RestockToasterInputImpl otherImpl = (RestockToasterInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<RestockToasterInput>>, Augmentation<RestockToasterInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"RestockToasterInput");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_amountOfBreadToStock", (Object)this._amountOfBreadToStock);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

