/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.mdsal.connector.ops.get;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.xml.MissingNameSpaceException;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.mdsal.connector.CurrentSchemaContext;
import org.opendaylight.netconf.mdsal.connector.ops.get.UniversalNamespaceContextImpl;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.codec.xml.XmlCodecFactory;
import org.opendaylight.yangtools.yang.data.impl.codec.TypeDefinitionAwareCodec;
import org.opendaylight.yangtools.yang.data.util.ParserStreamUtils;
import org.opendaylight.yangtools.yang.data.util.codec.TypeAwareCodec;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.TypedDataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class FilterContentValidator {
    private static final Logger LOG = LoggerFactory.getLogger(FilterContentValidator.class);
    private final CurrentSchemaContext schemaContext;

    public FilterContentValidator(CurrentSchemaContext schemaContext) {
        this.schemaContext = schemaContext;
    }

    public YangInstanceIdentifier validate(XmlElement filterContent) throws DocumentedException {
        try {
            URI namespace = new URI(filterContent.getNamespace());
            Module module = (Module)this.schemaContext.getCurrentContext().findModules(namespace).iterator().next();
            DataSchemaNode schema = this.getRootDataSchemaNode(module, namespace, filterContent.getName());
            FilterTree filterTree = this.validateNode(filterContent, schema, new FilterTree(schema.getQName(), Type.OTHER, schema));
            return this.getFilterDataRoot(filterTree, filterContent, YangInstanceIdentifier.builder());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Wrong namespace in element + " + filterContent.toString(), e);
        }
        catch (ValidationException e) {
            LOG.debug("Filter content isn't valid", (Throwable)e);
            throw new DocumentedException("Validation failed. Cause: " + e.getMessage(), (Exception)e, DocumentedException.ErrorType.APPLICATION, DocumentedException.ErrorTag.UNKNOWN_NAMESPACE, DocumentedException.ErrorSeverity.ERROR);
        }
    }

    private DataSchemaNode getRootDataSchemaNode(Module module, URI nameSpace, String name) throws DocumentedException {
        Collection childNodes = module.getChildNodes();
        for (DataSchemaNode childNode : childNodes) {
            QName qName = childNode.getQName();
            if (!qName.getNamespace().equals(nameSpace) || !qName.getLocalName().equals(name)) continue;
            return childNode;
        }
        throw new DocumentedException("Unable to find node with namespace: " + nameSpace + "in schema context: " + this.schemaContext.getCurrentContext().toString(), DocumentedException.ErrorType.APPLICATION, DocumentedException.ErrorTag.UNKNOWN_NAMESPACE, DocumentedException.ErrorSeverity.ERROR);
    }

    private FilterTree validateNode(XmlElement element, DataSchemaNode parentNodeSchema, FilterTree tree) throws ValidationException {
        List childElements = element.getChildElements();
        for (XmlElement childElement : childElements) {
            try {
                Deque path = ParserStreamUtils.findSchemaNodeByNameAndNamespace((DataSchemaNode)parentNodeSchema, (String)childElement.getName(), (URI)new URI(childElement.getNamespace()));
                if (path.isEmpty()) {
                    throw new ValidationException(element, childElement);
                }
                FilterTree subtree = tree;
                for (DataSchemaNode dataSchemaNode : path) {
                    subtree = subtree.addChild(dataSchemaNode);
                }
                DataSchemaNode childSchema = (DataSchemaNode)path.getLast();
                this.validateNode(childElement, childSchema, subtree);
            }
            catch (URISyntaxException | MissingNameSpaceException e) {
                throw new RuntimeException("Wrong namespace in element + " + childElement.toString(), e);
            }
        }
        return tree;
    }

    private YangInstanceIdentifier getFilterDataRoot(FilterTree tree, XmlElement filterContent, YangInstanceIdentifier.InstanceIdentifierBuilder builder) {
        builder.node(tree.getName());
        ArrayList<String> path = new ArrayList<String>();
        while (tree.getChildren().size() == 1) {
            FilterTree child = tree.getChildren().iterator().next();
            if (child.getType() == Type.CHOICE_CASE) {
                tree = child;
                continue;
            }
            builder.node(child.getName());
            path.add(child.getName().getLocalName());
            if (child.getType() == Type.LIST) {
                this.appendKeyIfPresent(child, filterContent, path, builder);
                return builder.build();
            }
            tree = child;
        }
        return builder.build();
    }

    private void appendKeyIfPresent(FilterTree tree, XmlElement filterContent, List<String> pathToList, YangInstanceIdentifier.InstanceIdentifierBuilder builder) {
        Preconditions.checkArgument((boolean)(tree.getSchemaNode() instanceof ListSchemaNode));
        ListSchemaNode listSchemaNode = (ListSchemaNode)tree.getSchemaNode();
        Map<QName, Object> map = this.getKeyValues(pathToList, filterContent, listSchemaNode);
        if (!map.isEmpty()) {
            builder.nodeWithKey(tree.getName(), map);
        }
    }

    private Map<QName, Object> getKeyValues(List<String> path, XmlElement filterContent, ListSchemaNode listSchemaNode) {
        XmlElement current = filterContent;
        for (String pathElement : path) {
            List childElements = current.getChildElements(pathElement);
            if (childElements.size() != 1) {
                return Collections.emptyMap();
            }
            current = (XmlElement)childElements.get(0);
        }
        HashMap<QName, Object> keys = new HashMap<QName, Object>();
        List keyDefinition = listSchemaNode.getKeyDefinition();
        for (QName qualifiedName : keyDefinition) {
            Optional childElements = current.getOnlyChildElementOptionally(qualifiedName.getLocalName());
            if (!childElements.isPresent()) {
                return Collections.emptyMap();
            }
            Optional keyValue = ((XmlElement)childElements.get()).getOnlyTextContentOptionally();
            if (!keyValue.isPresent()) continue;
            LeafSchemaNode listKey = (LeafSchemaNode)listSchemaNode.getDataChildByName(qualifiedName);
            if (listKey instanceof IdentityrefTypeDefinition) {
                keys.put(qualifiedName, keyValue.get());
                continue;
            }
            TypeDefinition keyType = listKey.getType();
            if (keyType instanceof IdentityrefTypeDefinition || keyType instanceof LeafrefTypeDefinition) {
                Document document = filterContent.getDomElement().getOwnerDocument();
                UniversalNamespaceContextImpl nsContext = new UniversalNamespaceContextImpl(document, false);
                XmlCodecFactory xmlCodecFactory = XmlCodecFactory.create((SchemaContext)this.schemaContext.getCurrentContext());
                TypeAwareCodec typeCodec = xmlCodecFactory.codecFor((TypedDataSchemaNode)listKey);
                Object deserializedKeyValue = typeCodec.parseValue((Object)nsContext, (String)keyValue.get());
                keys.put(qualifiedName, deserializedKeyValue);
                continue;
            }
            Object deserializedKey = TypeDefinitionAwareCodec.from((TypeDefinition)keyType).deserialize((String)keyValue.get());
            keys.put(qualifiedName, deserializedKey);
        }
        return keys;
    }

    private static class ValidationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        ValidationException(XmlElement parent, XmlElement child) {
            super("Element " + child + " can't be child of " + parent);
        }
    }

    private static class FilterTree {
        private final QName name;
        private final Type type;
        private final DataSchemaNode schemaNode;
        private final Map<QName, FilterTree> children;

        FilterTree(QName name, Type type, DataSchemaNode schemaNode) {
            this.name = name;
            this.type = type;
            this.schemaNode = schemaNode;
            this.children = new HashMap<QName, FilterTree>();
        }

        FilterTree addChild(DataSchemaNode data) {
            Type childType = data instanceof CaseSchemaNode ? Type.CHOICE_CASE : (data instanceof ListSchemaNode ? Type.LIST : Type.OTHER);
            QName childName = data.getQName();
            FilterTree childTree = this.children.get(childName);
            if (childTree == null) {
                childTree = new FilterTree(childName, childType, data);
            }
            this.children.put(childName, childTree);
            return childTree;
        }

        Collection<FilterTree> getChildren() {
            return this.children.values();
        }

        QName getName() {
            return this.name;
        }

        Type getType() {
            return this.type;
        }

        DataSchemaNode getSchemaNode() {
            return this.schemaNode;
        }
    }

    private static enum Type {
        LIST,
        CHOICE_CASE,
        OTHER;

    }
}

