/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.mdsal.connector.ops;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.mdsal.connector.TransactionProvider;
import org.opendaylight.netconf.mdsal.connector.ops.AbstractConfigOperation;
import org.opendaylight.netconf.mdsal.connector.ops.Datastore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class Validate
extends AbstractConfigOperation {
    private static final Logger LOG = LoggerFactory.getLogger(Validate.class);
    private static final String OPERATION_NAME = "validate";
    private static final String SOURCE_KEY = "source";
    private final TransactionProvider transactionProvider;

    public Validate(String netconfSessionIdForReporting, TransactionProvider transactionProvider) {
        super(netconfSessionIdForReporting);
        this.transactionProvider = transactionProvider;
    }

    protected Element handleWithNoSubsequentOperations(Document document, XmlElement operationElement) throws DocumentedException {
        Datastore targetDatastore = Validate.extractSourceParameter(operationElement, OPERATION_NAME);
        if (targetDatastore != Datastore.candidate) {
            throw new DocumentedException("<validate> is only supported on candidate datastore", DocumentedException.ErrorType.PROTOCOL, DocumentedException.ErrorTag.OPERATION_NOT_SUPPORTED, DocumentedException.ErrorSeverity.ERROR);
        }
        this.transactionProvider.validateTransaction();
        LOG.trace("<validate> request completed successfully on session {}", (Object)this.getNetconfSessionIdForReporting());
        return document.createElement("ok");
    }

    protected static Datastore extractSourceParameter(XmlElement operationElement, String operationName) throws DocumentedException {
        NodeList elementsByTagName = Validate.getElementsByTagName(operationElement, SOURCE_KEY);
        if (elementsByTagName.getLength() == 0) {
            ImmutableMap errorInfo = ImmutableMap.of((Object)"bad-attribute", (Object)SOURCE_KEY, (Object)"bad-element", (Object)operationName);
            throw new DocumentedException("Missing source element", DocumentedException.ErrorType.PROTOCOL, DocumentedException.ErrorTag.MISSING_ELEMENT, DocumentedException.ErrorSeverity.ERROR, (Map)errorInfo);
        }
        if (elementsByTagName.getLength() > 1) {
            throw new DocumentedException("Multiple source elements", DocumentedException.ErrorType.RPC, DocumentedException.ErrorTag.UNKNOWN_ATTRIBUTE, DocumentedException.ErrorSeverity.ERROR);
        }
        XmlElement sourceChildNode = XmlElement.fromDomElement((Element)((Element)elementsByTagName.item(0))).getOnlyChildElement();
        return Datastore.valueOf(sourceChildNode.getName());
    }

    protected String getOperationName() {
        return OPERATION_NAME;
    }
}

