/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.mdsal.connector.ops;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadWriteTransaction;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.mdsal.connector.CurrentSchemaContext;
import org.opendaylight.netconf.mdsal.connector.TransactionProvider;
import org.opendaylight.netconf.mdsal.connector.ops.AbstractEdit;
import org.opendaylight.netconf.mdsal.connector.ops.DataTreeChangeTracker;
import org.opendaylight.netconf.mdsal.connector.ops.Datastore;
import org.opendaylight.netconf.mdsal.connector.ops.EditOperationNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.api.ModifyAction;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AugmentationNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizedNodeResult;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.util.SchemaContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class EditConfig
extends AbstractEdit {
    private static final Logger LOG = LoggerFactory.getLogger(EditConfig.class);
    private static final String OPERATION_NAME = "edit-config";
    private static final String DEFAULT_OPERATION_KEY = "default-operation";
    private final TransactionProvider transactionProvider;

    public EditConfig(String netconfSessionIdForReporting, CurrentSchemaContext schemaContext, TransactionProvider transactionProvider) {
        super(netconfSessionIdForReporting, schemaContext);
        this.transactionProvider = transactionProvider;
    }

    protected Element handleWithNoSubsequentOperations(Document document, XmlElement operationElement) throws DocumentedException {
        XmlElement targetElement = EditConfig.extractTargetElement(operationElement, OPERATION_NAME);
        Datastore targetDatastore = Datastore.valueOf(targetElement.getName());
        if (targetDatastore == Datastore.running) {
            throw new DocumentedException("edit-config on running datastore is not supported", DocumentedException.ErrorType.PROTOCOL, DocumentedException.ErrorTag.OPERATION_NOT_SUPPORTED, DocumentedException.ErrorSeverity.ERROR);
        }
        ModifyAction defaultAction = EditConfig.getDefaultOperation(operationElement);
        XmlElement configElement = EditConfig.getConfigElement(operationElement);
        for (XmlElement element : configElement.getChildElements()) {
            String ns = element.getNamespace();
            DataSchemaNode schemaNode = this.getSchemaNodeFromNamespace(ns, element);
            DataTreeChangeTracker changeTracker = new DataTreeChangeTracker(defaultAction);
            this.parseIntoNormalizedNode(schemaNode, element, (NormalizedNodeStreamWriter)new EditOperationNormalizedNodeStreamWriter(new NormalizedNodeResult(), changeTracker));
            this.executeOperations(changeTracker);
        }
        return document.createElement("ok");
    }

    private void executeOperations(DataTreeChangeTracker changeTracker) throws DocumentedException {
        DOMDataTreeReadWriteTransaction rwTx = this.transactionProvider.getOrCreateTransaction();
        ArrayList<DataTreeChangeTracker.DataTreeChange> aa = changeTracker.getDataTreeChanges();
        ListIterator iterator = aa.listIterator(aa.size());
        while (iterator.hasPrevious()) {
            DataTreeChangeTracker.DataTreeChange dtc = (DataTreeChangeTracker.DataTreeChange)iterator.previous();
            this.executeChange(rwTx, dtc);
        }
    }

    private void executeChange(DOMDataTreeReadWriteTransaction rwtx, DataTreeChangeTracker.DataTreeChange change) throws DocumentedException {
        YangInstanceIdentifier path = YangInstanceIdentifier.create(change.getPath());
        NormalizedNode<?, ?> changeData = change.getChangeRoot();
        switch (change.getAction()) {
            case NONE: {
                return;
            }
            case MERGE: {
                this.mergeParentMixin(rwtx, path, changeData);
                rwtx.merge(LogicalDatastoreType.CONFIGURATION, path, changeData);
                break;
            }
            case CREATE: {
                try {
                    if (((Optional)rwtx.read(LogicalDatastoreType.CONFIGURATION, path).get()).isPresent()) {
                        throw new DocumentedException("Data already exists, cannot execute CREATE operation", DocumentedException.ErrorType.PROTOCOL, DocumentedException.ErrorTag.DATA_EXISTS, DocumentedException.ErrorSeverity.ERROR);
                    }
                    this.mergeParentMixin(rwtx, path, changeData);
                    rwtx.put(LogicalDatastoreType.CONFIGURATION, path, changeData);
                }
                catch (InterruptedException | ExecutionException e) {
                    LOG.warn("Read from datastore failed when trying to read data for create operation {}", (Object)change, (Object)e);
                }
                break;
            }
            case REPLACE: {
                this.mergeParentMixin(rwtx, path, changeData);
                rwtx.put(LogicalDatastoreType.CONFIGURATION, path, changeData);
                break;
            }
            case DELETE: {
                try {
                    if (!((Optional)rwtx.read(LogicalDatastoreType.CONFIGURATION, path).get()).isPresent()) {
                        throw new DocumentedException("Data is missing, cannot execute DELETE operation", DocumentedException.ErrorType.PROTOCOL, DocumentedException.ErrorTag.DATA_MISSING, DocumentedException.ErrorSeverity.ERROR);
                    }
                    rwtx.delete(LogicalDatastoreType.CONFIGURATION, path);
                }
                catch (InterruptedException | ExecutionException e) {
                    LOG.warn("Read from datastore failed when trying to read data for delete operation {}", (Object)change, (Object)e);
                }
                break;
            }
            case REMOVE: {
                rwtx.delete(LogicalDatastoreType.CONFIGURATION, path);
                break;
            }
            default: {
                LOG.warn("Unknown/not implemented operation, not executing");
            }
        }
    }

    private void mergeParentMixin(DOMDataTreeReadWriteTransaction rwtx, YangInstanceIdentifier path, NormalizedNode<?, ?> change) {
        YangInstanceIdentifier parentNodeYid = path.getParent();
        if (change instanceof MapEntryNode) {
            SchemaNode schemaNode = SchemaContextUtil.findNodeInSchemaContext((SchemaContext)this.schemaContext.getCurrentContext(), (Iterable)parentNodeYid.getPathArguments().stream().filter(arg -> !(arg instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates)).filter(arg -> !(arg instanceof YangInstanceIdentifier.AugmentationIdentifier)).map(YangInstanceIdentifier.PathArgument::getNodeType).collect(Collectors.toList()));
            Preconditions.checkState((boolean)(schemaNode instanceof ListSchemaNode), (Object)"Schema node is not pointing to a list.");
            if (((ListSchemaNode)schemaNode).isUserOrdered()) {
                MapNode mixinNode = (MapNode)Builders.orderedMapBuilder().withNodeIdentifier(new YangInstanceIdentifier.NodeIdentifier(parentNodeYid.getLastPathArgument().getNodeType())).build();
                rwtx.merge(LogicalDatastoreType.CONFIGURATION, parentNodeYid, (NormalizedNode)mixinNode);
                return;
            }
            MapNode mixinNode = (MapNode)Builders.mapBuilder().withNodeIdentifier(new YangInstanceIdentifier.NodeIdentifier(parentNodeYid.getLastPathArgument().getNodeType())).build();
            rwtx.merge(LogicalDatastoreType.CONFIGURATION, parentNodeYid, (NormalizedNode)mixinNode);
        } else if (parentNodeYid.getLastPathArgument() instanceof YangInstanceIdentifier.AugmentationIdentifier) {
            YangInstanceIdentifier.AugmentationIdentifier augmentationYid = (YangInstanceIdentifier.AugmentationIdentifier)parentNodeYid.getLastPathArgument();
            AugmentationNode augmentationNode = (AugmentationNode)Builders.augmentationBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)augmentationYid).build();
            rwtx.merge(LogicalDatastoreType.CONFIGURATION, parentNodeYid, (NormalizedNode)augmentationNode);
        }
    }

    private static ModifyAction getDefaultOperation(XmlElement operationElement) throws DocumentedException {
        NodeList elementsByTagName = EditConfig.getElementsByTagName(operationElement, DEFAULT_OPERATION_KEY);
        if (elementsByTagName.getLength() == 0) {
            return ModifyAction.MERGE;
        }
        if (elementsByTagName.getLength() > 1) {
            throw new DocumentedException("Multiple default-operation elements", DocumentedException.ErrorType.RPC, DocumentedException.ErrorTag.UNKNOWN_ATTRIBUTE, DocumentedException.ErrorSeverity.ERROR);
        }
        return ModifyAction.fromXmlValue((String)elementsByTagName.item(0).getTextContent());
    }

    protected String getOperationName() {
        return OPERATION_NAME;
    }
}

