/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.mdsal.connector.ops;

import java.util.HashMap;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.mdsal.connector.TransactionProvider;
import org.opendaylight.netconf.util.mapping.AbstractSingletonNetconfOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DiscardChanges
extends AbstractSingletonNetconfOperation {
    private static final Logger LOG = LoggerFactory.getLogger(DiscardChanges.class);
    private static final String OPERATION_NAME = "discard-changes";
    private final TransactionProvider transactionProvider;

    public DiscardChanges(String netconfSessionIdForReporting, TransactionProvider transactionProvider) {
        super(netconfSessionIdForReporting);
        this.transactionProvider = transactionProvider;
    }

    protected Element handleWithNoSubsequentOperations(Document document, XmlElement operationElement) throws DocumentedException {
        try {
            this.transactionProvider.abortTransaction();
        }
        catch (IllegalStateException e) {
            LOG.warn("Abort failed ", (Throwable)e);
            HashMap<String, String> errorInfo = new HashMap<String, String>();
            errorInfo.put(DocumentedException.ErrorTag.OPERATION_FAILED.name(), "Operation failed. Use 'get-config' or 'edit-config' before triggering discard-changes operation");
            throw new DocumentedException(e.getMessage(), (Exception)e, DocumentedException.ErrorType.APPLICATION, DocumentedException.ErrorTag.OPERATION_FAILED, DocumentedException.ErrorSeverity.ERROR, errorInfo);
        }
        return document.createElement("ok");
    }

    protected String getOperationName() {
        return OPERATION_NAME;
    }
}

