/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.mdsal.connector.ops;

import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import javax.xml.transform.dom.DOMSource;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.NetconfDocumentedException;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.mdsal.connector.CurrentSchemaContext;
import org.opendaylight.netconf.mdsal.connector.ops.AbstractConfigOperation;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.XmlParserStream;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

abstract class AbstractEdit
extends AbstractConfigOperation {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractEdit.class);
    private static final String TARGET_KEY = "target";
    protected final CurrentSchemaContext schemaContext;

    protected AbstractEdit(String netconfSessionIdForReporting, CurrentSchemaContext schemaContext) {
        super(netconfSessionIdForReporting);
        this.schemaContext = schemaContext;
    }

    protected void parseIntoNormalizedNode(DataSchemaNode schemaNode, XmlElement element, NormalizedNodeStreamWriter writer) throws DocumentedException {
        if (!(schemaNode instanceof ContainerSchemaNode) && !(schemaNode instanceof ListSchemaNode)) {
            LOG.debug("DataNode from module is not ContainerSchemaNode nor ListSchemaNode, aborting..");
            throw new UnsupportedOperationException("implement exception if parse fails");
        }
        XmlParserStream xmlParser = XmlParserStream.create((NormalizedNodeStreamWriter)writer, (SchemaContext)this.schemaContext.getCurrentContext(), (SchemaNode)schemaNode);
        try {
            xmlParser.traverse(new DOMSource(element.getDomElement()));
        }
        catch (Exception ex) {
            throw new NetconfDocumentedException("Error parsing input: " + ex.getMessage(), ex, DocumentedException.ErrorType.PROTOCOL, DocumentedException.ErrorTag.MALFORMED_MESSAGE, DocumentedException.ErrorSeverity.ERROR);
        }
    }

    protected DataSchemaNode getSchemaNodeFromNamespace(String namespace, XmlElement element) throws DocumentedException {
        Iterator it;
        try {
            it = this.schemaContext.getCurrentContext().findModules(new URI(namespace)).iterator();
        }
        catch (URISyntaxException e) {
            throw new NetconfDocumentedException("Unable to create URI for namespace : " + namespace, (Exception)e, DocumentedException.ErrorType.APPLICATION, DocumentedException.ErrorTag.INVALID_VALUE, DocumentedException.ErrorSeverity.ERROR);
        }
        if (!it.hasNext()) {
            throw new NetconfDocumentedException("Unable to find module by namespace: " + namespace, DocumentedException.ErrorType.APPLICATION, DocumentedException.ErrorTag.UNKNOWN_NAMESPACE, DocumentedException.ErrorSeverity.ERROR);
        }
        Module module = (Module)it.next();
        String elementName = element.getName();
        Optional schemaNode = module.findDataChildByName(QName.create((QNameModule)module.getQNameModule(), (String)element.getName()));
        if (!schemaNode.isPresent()) {
            throw new DocumentedException("Unable to find node " + elementName + " with namespace: " + namespace + "in module: " + module.toString(), DocumentedException.ErrorType.APPLICATION, DocumentedException.ErrorTag.UNKNOWN_NAMESPACE, DocumentedException.ErrorSeverity.ERROR);
        }
        return (DataSchemaNode)schemaNode.get();
    }

    protected static XmlElement extractTargetElement(XmlElement operationElement, String operationName) throws DocumentedException {
        NodeList elementsByTagName = AbstractEdit.getElementsByTagName(operationElement, TARGET_KEY);
        if (elementsByTagName.getLength() == 0) {
            ImmutableMap errorInfo = ImmutableMap.of((Object)"bad-attribute", (Object)TARGET_KEY, (Object)"bad-element", (Object)operationName);
            throw new DocumentedException("Missing target element", DocumentedException.ErrorType.PROTOCOL, DocumentedException.ErrorTag.MISSING_ATTRIBUTE, DocumentedException.ErrorSeverity.ERROR, (Map)errorInfo);
        }
        if (elementsByTagName.getLength() > 1) {
            throw new DocumentedException("Multiple target elements", DocumentedException.ErrorType.RPC, DocumentedException.ErrorTag.UNKNOWN_ATTRIBUTE, DocumentedException.ErrorSeverity.ERROR);
        }
        return XmlElement.fromDomElement((Element)((Element)elementsByTagName.item(0))).getOnlyChildElement();
    }
}

