/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.mdsal.connector;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.netconf.mapping.api.NetconfOperation;
import org.opendaylight.netconf.mdsal.connector.CurrentSchemaContext;
import org.opendaylight.netconf.mdsal.connector.TransactionProvider;
import org.opendaylight.netconf.mdsal.connector.ops.Commit;
import org.opendaylight.netconf.mdsal.connector.ops.CopyConfig;
import org.opendaylight.netconf.mdsal.connector.ops.DiscardChanges;
import org.opendaylight.netconf.mdsal.connector.ops.EditConfig;
import org.opendaylight.netconf.mdsal.connector.ops.Lock;
import org.opendaylight.netconf.mdsal.connector.ops.RuntimeRpc;
import org.opendaylight.netconf.mdsal.connector.ops.Unlock;
import org.opendaylight.netconf.mdsal.connector.ops.Validate;
import org.opendaylight.netconf.mdsal.connector.ops.get.Get;
import org.opendaylight.netconf.mdsal.connector.ops.get.GetConfig;

final class OperationProvider {
    private final Set<NetconfOperation> operations;

    OperationProvider(String netconfSessionIdForReporting, CurrentSchemaContext schemaContext, DOMDataBroker dataBroker, DOMRpcService rpcService) {
        TransactionProvider transactionProvider = new TransactionProvider(dataBroker, netconfSessionIdForReporting);
        this.operations = ImmutableSet.of((Object)((Object)new Commit(netconfSessionIdForReporting, transactionProvider)), (Object)((Object)new DiscardChanges(netconfSessionIdForReporting, transactionProvider)), (Object)((Object)new EditConfig(netconfSessionIdForReporting, schemaContext, transactionProvider)), (Object)((Object)new CopyConfig(netconfSessionIdForReporting, schemaContext, transactionProvider)), (Object)((Object)new Get(netconfSessionIdForReporting, schemaContext, transactionProvider)), (Object)((Object)new GetConfig(netconfSessionIdForReporting, schemaContext, transactionProvider)), (Object[])new NetconfOperation[]{new Lock(netconfSessionIdForReporting), new Unlock(netconfSessionIdForReporting), new RuntimeRpc(netconfSessionIdForReporting, schemaContext, rpcService), new Validate(netconfSessionIdForReporting, transactionProvider)});
    }

    Set<NetconfOperation> getOperations() {
        return this.operations;
    }
}

