/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.mdsal.connector;

import com.google.common.base.Preconditions;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.mdsal.dom.api.DOMYangTextSourceProvider;
import org.opendaylight.netconf.api.capability.BasicCapability;
import org.opendaylight.netconf.api.capability.Capability;
import org.opendaylight.netconf.api.capability.YangModuleCapability;
import org.opendaylight.netconf.api.monitoring.CapabilityListener;
import org.opendaylight.netconf.mapping.api.NetconfOperationServiceFactory;
import org.opendaylight.netconf.mapping.api.NetconfOperationServiceFactoryListener;
import org.opendaylight.netconf.mdsal.connector.CurrentSchemaContext;
import org.opendaylight.netconf.mdsal.connector.DOMDataTransactionValidator;
import org.opendaylight.netconf.mdsal.connector.MdsalNetconfOperationService;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.repo.api.RevisionSourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MdsalNetconfOperationServiceFactory
implements NetconfOperationServiceFactory,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(MdsalNetconfOperationServiceFactory.class);
    private static final BasicCapability VALIDATE_CAPABILITY = new BasicCapability("urn:ietf:params:netconf:capability:validate:1.0");
    private final DOMDataBroker dataBroker;
    private final DOMRpcService rpcService;
    private final CurrentSchemaContext currentSchemaContext;
    private final SchemaSourceProvider<YangTextSchemaSource> rootSchemaSourceProviderDependency;
    private final NetconfOperationServiceFactoryListener netconfOperationServiceFactoryListener;

    public MdsalNetconfOperationServiceFactory(DOMSchemaService schemaService, NetconfOperationServiceFactoryListener netconfOperationServiceFactoryListener, DOMDataBroker dataBroker, DOMRpcService rpcService) {
        this.dataBroker = dataBroker;
        this.rpcService = rpcService;
        this.rootSchemaSourceProviderDependency = (SchemaSourceProvider)schemaService.getExtensions().getInstance(DOMYangTextSourceProvider.class);
        this.currentSchemaContext = new CurrentSchemaContext((DOMSchemaService)Preconditions.checkNotNull((Object)schemaService), this.rootSchemaSourceProviderDependency);
        this.netconfOperationServiceFactoryListener = netconfOperationServiceFactoryListener;
        this.netconfOperationServiceFactoryListener.onAddNetconfOperationServiceFactory((NetconfOperationServiceFactory)this);
    }

    public MdsalNetconfOperationService createService(String netconfSessionIdForReporting) {
        Preconditions.checkState((this.dataBroker != null ? 1 : 0) != 0, (Object)"MD-SAL provider not yet initialized");
        return new MdsalNetconfOperationService(this.currentSchemaContext, netconfSessionIdForReporting, this.dataBroker, this.rpcService);
    }

    @Override
    public void close() {
        try {
            this.currentSchemaContext.close();
            if (this.netconfOperationServiceFactoryListener != null) {
                this.netconfOperationServiceFactoryListener.onRemoveNetconfOperationServiceFactory((NetconfOperationServiceFactory)this);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to close resources correctly - ignore", (Throwable)e);
        }
    }

    public Set<Capability> getCapabilities() {
        return MdsalNetconfOperationServiceFactory.transformCapabilities(this.currentSchemaContext.getCurrentContext(), this.rootSchemaSourceProviderDependency);
    }

    static Set<Capability> transformCapabilities(SchemaContext currentContext, SchemaSourceProvider<YangTextSchemaSource> rootSchemaSourceProviderDependency) {
        HashSet<Capability> capabilities = new HashSet<Capability>();
        Set modules = currentContext.getModules();
        for (Module module : modules) {
            Optional<YangModuleCapability> cap = MdsalNetconfOperationServiceFactory.moduleToCapability(module, rootSchemaSourceProviderDependency);
            if (cap.isPresent()) {
                capabilities.add((Capability)cap.get());
            }
            for (Module submodule : module.getSubmodules()) {
                cap = MdsalNetconfOperationServiceFactory.moduleToCapability(submodule, rootSchemaSourceProviderDependency);
                if (!cap.isPresent()) continue;
                capabilities.add((Capability)cap.get());
            }
        }
        return capabilities;
    }

    private static Optional<YangModuleCapability> moduleToCapability(Module module, SchemaSourceProvider<YangTextSchemaSource> rootSchemaSourceProviderDependency) {
        String source;
        RevisionSourceIdentifier moduleSourceIdentifier = RevisionSourceIdentifier.create((String)module.getName(), (Optional)module.getRevision());
        InputStream sourceStream = null;
        try {
            sourceStream = ((YangTextSchemaSource)rootSchemaSourceProviderDependency.getSource((SourceIdentifier)moduleSourceIdentifier).get()).openStream();
            source = CharStreams.toString((Readable)new InputStreamReader(sourceStream, StandardCharsets.UTF_8));
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            LOG.warn("Ignoring source for module {}. Unable to read content", (Object)moduleSourceIdentifier, (Object)e);
            source = null;
        }
        try {
            if (sourceStream != null) {
                sourceStream.close();
            }
        }
        catch (IOException e) {
            LOG.warn("Error closing yang source stream {}. Ignoring", (Object)moduleSourceIdentifier, (Object)e);
        }
        if (source != null) {
            return Optional.of(new YangModuleCapability(module, source));
        }
        LOG.warn("Missing source for module {}. This module will not be available from netconf server", (Object)moduleSourceIdentifier);
        return Optional.empty();
    }

    public AutoCloseable registerCapabilityListener(CapabilityListener listener) {
        if (this.dataBroker.getExtensions().get(DOMDataTransactionValidator.class) != null) {
            listener.onCapabilitiesChanged(Collections.singleton(VALIDATE_CAPABILITY), Collections.emptySet());
        }
        return this.currentSchemaContext.registerCapabilityListener(listener);
    }
}

