/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.mdsal.connector;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.netconf.api.capability.Capability;
import org.opendaylight.netconf.api.monitoring.CapabilityListener;
import org.opendaylight.netconf.mdsal.connector.MdsalNetconfOperationServiceFactory;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContextListener;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceProvider;

public class CurrentSchemaContext
implements SchemaContextListener,
AutoCloseable {
    private final AtomicReference<SchemaContext> currentContext = new AtomicReference();
    private final ListenerRegistration<SchemaContextListener> schemaContextListenerListenerRegistration;
    private final Set<CapabilityListener> listeners1 = Collections.synchronizedSet(new HashSet());
    private final SchemaSourceProvider<YangTextSchemaSource> rootSchemaSourceProvider;

    public SchemaContext getCurrentContext() {
        Preconditions.checkState((this.currentContext.get() != null ? 1 : 0) != 0, (Object)"Current context not received");
        return this.currentContext.get();
    }

    public CurrentSchemaContext(DOMSchemaService schemaService, SchemaSourceProvider<YangTextSchemaSource> rootSchemaSourceProvider) {
        this.rootSchemaSourceProvider = rootSchemaSourceProvider;
        this.schemaContextListenerListenerRegistration = schemaService.registerSchemaContextListener((SchemaContextListener)this);
    }

    public void onGlobalContextUpdated(SchemaContext schemaContext) {
        this.currentContext.set(schemaContext);
        Set<Capability> addedCaps = MdsalNetconfOperationServiceFactory.transformCapabilities(this.currentContext.get(), this.rootSchemaSourceProvider);
        for (CapabilityListener listener : this.listeners1) {
            listener.onCapabilitiesChanged(addedCaps, Collections.emptySet());
        }
    }

    @Override
    public void close() {
        this.listeners1.clear();
        this.schemaContextListenerListenerRegistration.close();
        this.currentContext.set(null);
    }

    public AutoCloseable registerCapabilityListener(CapabilityListener listener) {
        listener.onCapabilitiesChanged(MdsalNetconfOperationServiceFactory.transformCapabilities(this.currentContext.get(), this.rootSchemaSourceProvider), Collections.emptySet());
        this.listeners1.add(listener);
        return () -> this.listeners1.remove(listener);
    }
}

