/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.impl;

import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.opendaylight.controller.md.sal.binding.api.NotificationService;
import org.opendaylight.controller.md.sal.binding.impl.BindingDOMAdapterBuilder;
import org.opendaylight.controller.md.sal.binding.impl.BindingDOMNotificationListenerAdapter;
import org.opendaylight.controller.md.sal.binding.impl.BindingToNormalizedNodeCodec;
import org.opendaylight.controller.md.sal.dom.api.DOMNotificationListener;
import org.opendaylight.controller.md.sal.dom.api.DOMNotificationService;
import org.opendaylight.controller.md.sal.dom.api.DOMService;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.yangtools.concepts.AbstractListenerRegistration;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.NotificationListener;

public class BindingDOMNotificationServiceAdapter
implements NotificationService,
AutoCloseable {
    public static final BindingDOMAdapterBuilder.Factory<NotificationService> BUILDER_FACTORY = () -> new Builder();
    private final BindingNormalizedNodeSerializer codec;
    private final DOMNotificationService domNotifService;

    public BindingDOMNotificationServiceAdapter(BindingNormalizedNodeSerializer codec, DOMNotificationService domNotifService) {
        this.codec = codec;
        this.domNotifService = domNotifService;
    }

    public <T extends NotificationListener> ListenerRegistration<T> registerNotificationListener(T listener) {
        BindingDOMNotificationListenerAdapter domListener = new BindingDOMNotificationListenerAdapter(this.codec, listener);
        ListenerRegistration domRegistration = this.domNotifService.registerNotificationListener((DOMNotificationListener)domListener, domListener.getSupportedNotifications());
        return new ListenerRegistrationImpl<T>(listener, domRegistration);
    }

    @Override
    public void close() {
    }

    public DOMNotificationService getDomService() {
        return this.domNotifService;
    }

    private static class Builder
    extends BindingDOMAdapterBuilder<NotificationService> {
        private Builder() {
        }

        @Override
        protected NotificationService createInstance(BindingToNormalizedNodeCodec codec, ClassToInstanceMap<DOMService> delegates) {
            DOMNotificationService domNotification = (DOMNotificationService)delegates.getInstance(DOMNotificationService.class);
            return new BindingDOMNotificationServiceAdapter((BindingNormalizedNodeSerializer)codec.getCodecRegistry(), domNotification);
        }

        @Override
        public Set<? extends Class<? extends DOMService>> getRequiredDelegates() {
            return ImmutableSet.of(DOMNotificationService.class);
        }
    }

    private static class ListenerRegistrationImpl<T extends NotificationListener>
    extends AbstractListenerRegistration<T> {
        private final ListenerRegistration<?> listenerRegistration;

        ListenerRegistrationImpl(T listener, ListenerRegistration<?> listenerRegistration) {
            super(listener);
            this.listenerRegistration = listenerRegistration;
        }

        protected void removeRegistration() {
            this.listenerRegistration.close();
        }
    }
}

