/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.compat;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.opendaylight.controller.md.sal.binding.compat.NotificationListenerRegistration;
import org.opendaylight.yangtools.yang.binding.Notification;

final class ListenerMapGeneration {
    private static final int CACHE_MAX_ENTRIES = 1000;
    private final Multimap<Class<? extends Notification>, NotificationListenerRegistration<?>> typeToListeners;
    private final LoadingCache<Class<?>, Iterable<NotificationListenerRegistration<?>>> implementationToListeners = CacheBuilder.newBuilder().weakKeys().maximumSize(1000L).build(new CacheLoader<Class<?>, Iterable<NotificationListenerRegistration<?>>>(){

        public Iterable<NotificationListenerRegistration<?>> load(Class<?> key) {
            HashSet regs = new HashSet();
            for (Class type : ListenerMapGeneration.getNotificationTypes(key)) {
                Collection l = ListenerMapGeneration.this.typeToListeners.get((Object)type);
                if (l == null) continue;
                regs.addAll(l);
            }
            return ImmutableSet.copyOf(regs);
        }
    });

    ListenerMapGeneration() {
        this.typeToListeners = ImmutableMultimap.of();
    }

    ListenerMapGeneration(Multimap<Class<? extends Notification>, NotificationListenerRegistration<?>> listeners) {
        this.typeToListeners = ImmutableMultimap.copyOf(listeners);
    }

    Multimap<Class<? extends Notification>, NotificationListenerRegistration<?>> getListeners() {
        return this.typeToListeners;
    }

    public Iterable<NotificationListenerRegistration<?>> listenersFor(Notification notification) {
        return (Iterable)this.implementationToListeners.getUnchecked(notification.getClass());
    }

    public Iterable<Class<? extends Notification>> getKnownTypes() {
        return this.typeToListeners.keySet();
    }

    private static Iterable<Class<?>> getNotificationTypes(Class<?> cls) {
        Class<?>[] ifaces = cls.getInterfaces();
        return Arrays.stream(ifaces).filter(input -> !Notification.class.equals(input) && Notification.class.isAssignableFrom((Class<?>)input)).collect(Collectors.toList());
    }
}

