/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.peer;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.Endpoint;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.peer.DataOperationalEndpoints;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.peer.DataOperationalEndpointsKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class DataOperationalEndpointsBuilder
implements Builder<DataOperationalEndpoints> {
    private Uri _endpointUri;
    private String _path;
    private DataOperationalEndpointsKey key;
    Map<Class<? extends Augmentation<DataOperationalEndpoints>>, Augmentation<DataOperationalEndpoints>> augmentation = Collections.emptyMap();

    public DataOperationalEndpointsBuilder() {
    }

    public DataOperationalEndpointsBuilder(Endpoint arg) {
        this._path = arg.getPath();
        this._endpointUri = arg.getEndpointUri();
    }

    public DataOperationalEndpointsBuilder(DataOperationalEndpoints base) {
        Map aug;
        this.key = base.key();
        this._path = base.getPath();
        this._endpointUri = base.getEndpointUri();
        if (base instanceof DataOperationalEndpointsImpl) {
            DataOperationalEndpointsImpl impl = (DataOperationalEndpointsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<DataOperationalEndpoints>>, Augmentation<DataOperationalEndpoints>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<DataOperationalEndpoints>>, Augmentation<DataOperationalEndpoints>>(aug);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Endpoint) {
            this._path = ((Endpoint)arg).getPath();
            this._endpointUri = ((Endpoint)arg).getEndpointUri();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.Endpoint]");
    }

    public DataOperationalEndpointsKey key() {
        return this.key;
    }

    public Uri getEndpointUri() {
        return this._endpointUri;
    }

    public String getPath() {
        return this._path;
    }

    public <E$$ extends Augmentation<DataOperationalEndpoints>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public DataOperationalEndpointsBuilder withKey(DataOperationalEndpointsKey key) {
        this.key = key;
        return this;
    }

    public DataOperationalEndpointsBuilder setEndpointUri(Uri value) {
        this._endpointUri = value;
        return this;
    }

    public DataOperationalEndpointsBuilder setPath(String value) {
        this._path = value;
        return this;
    }

    public DataOperationalEndpointsBuilder addAugmentation(Class<? extends Augmentation<DataOperationalEndpoints>> augmentationType, Augmentation<DataOperationalEndpoints> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<DataOperationalEndpoints>>, Augmentation<DataOperationalEndpoints>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public DataOperationalEndpointsBuilder removeAugmentation(Class<? extends Augmentation<DataOperationalEndpoints>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public DataOperationalEndpoints build() {
        return new DataOperationalEndpointsImpl(this);
    }

    private static final class DataOperationalEndpointsImpl
    implements DataOperationalEndpoints {
        private final Uri _endpointUri;
        private final String _path;
        private final DataOperationalEndpointsKey key;
        private Map<Class<? extends Augmentation<DataOperationalEndpoints>>, Augmentation<DataOperationalEndpoints>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        DataOperationalEndpointsImpl(DataOperationalEndpointsBuilder base) {
            this.key = base.key() != null ? base.key() : new DataOperationalEndpointsKey(base.getPath());
            this._path = this.key.getPath();
            this._endpointUri = base.getEndpointUri();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<DataOperationalEndpoints> getImplementedInterface() {
            return DataOperationalEndpoints.class;
        }

        @Override
        public DataOperationalEndpointsKey key() {
            return this.key;
        }

        @Override
        public Uri getEndpointUri() {
            return this._endpointUri;
        }

        @Override
        public String getPath() {
            return this._path;
        }

        public <E$$ extends Augmentation<DataOperationalEndpoints>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._endpointUri);
            result = 31 * result + Objects.hashCode(this._path);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!DataOperationalEndpoints.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            DataOperationalEndpoints other = (DataOperationalEndpoints)obj;
            if (!Objects.equals(this._endpointUri, other.getEndpointUri())) {
                return false;
            }
            if (!Objects.equals(this._path, other.getPath())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                DataOperationalEndpointsImpl otherImpl = (DataOperationalEndpointsImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<DataOperationalEndpoints>>, Augmentation<DataOperationalEndpoints>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"DataOperationalEndpoints");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_endpointUri", (Object)this._endpointUri);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_path", (Object)this._path);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

