/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.config;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.YangIdentifier;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.Entity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.Peer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.config.ActualEndpoints;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.config.ActualEndpointsKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.peer.DataConfigEndpoints;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.peer.DataOperationalEndpoints;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.peer.NotificationEndpoints;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.peer.RpcEndpoints;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ActualEndpointsBuilder
implements Builder<ActualEndpoints> {
    private List<DataConfigEndpoints> _dataConfigEndpoints;
    private List<DataOperationalEndpoints> _dataOperationalEndpoints;
    private List<YangIdentifier> _modules;
    private String _name;
    private List<NotificationEndpoints> _notificationEndpoints;
    private List<RpcEndpoints> _rpcEndpoints;
    private ActualEndpointsKey key;
    Map<Class<? extends Augmentation<ActualEndpoints>>, Augmentation<ActualEndpoints>> augmentation = Collections.emptyMap();

    public ActualEndpointsBuilder() {
    }

    public ActualEndpointsBuilder(Peer arg) {
        this._dataConfigEndpoints = arg.getDataConfigEndpoints();
        this._dataOperationalEndpoints = arg.getDataOperationalEndpoints();
        this._rpcEndpoints = arg.getRpcEndpoints();
        this._notificationEndpoints = arg.getNotificationEndpoints();
        this._name = arg.getName();
        this._modules = arg.getModules();
    }

    public ActualEndpointsBuilder(Entity arg) {
        this._name = arg.getName();
        this._modules = arg.getModules();
    }

    public ActualEndpointsBuilder(ActualEndpoints base) {
        Map aug;
        this.key = base.key();
        this._name = base.getName();
        this._dataConfigEndpoints = base.getDataConfigEndpoints();
        this._dataOperationalEndpoints = base.getDataOperationalEndpoints();
        this._modules = base.getModules();
        this._notificationEndpoints = base.getNotificationEndpoints();
        this._rpcEndpoints = base.getRpcEndpoints();
        if (base instanceof ActualEndpointsImpl) {
            ActualEndpointsImpl impl = (ActualEndpointsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ActualEndpoints>>, Augmentation<ActualEndpoints>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ActualEndpoints>>, Augmentation<ActualEndpoints>>(aug);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Peer) {
            this._dataConfigEndpoints = ((Peer)arg).getDataConfigEndpoints();
            this._dataOperationalEndpoints = ((Peer)arg).getDataOperationalEndpoints();
            this._rpcEndpoints = ((Peer)arg).getRpcEndpoints();
            this._notificationEndpoints = ((Peer)arg).getNotificationEndpoints();
            isValidArg = true;
        }
        if (arg instanceof Entity) {
            this._name = ((Entity)arg).getName();
            this._modules = ((Entity)arg).getModules();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.Peer, org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.Entity]");
    }

    public ActualEndpointsKey key() {
        return this.key;
    }

    public List<DataConfigEndpoints> getDataConfigEndpoints() {
        return this._dataConfigEndpoints;
    }

    public List<DataOperationalEndpoints> getDataOperationalEndpoints() {
        return this._dataOperationalEndpoints;
    }

    public List<YangIdentifier> getModules() {
        return this._modules;
    }

    public String getName() {
        return this._name;
    }

    public List<NotificationEndpoints> getNotificationEndpoints() {
        return this._notificationEndpoints;
    }

    public List<RpcEndpoints> getRpcEndpoints() {
        return this._rpcEndpoints;
    }

    public <E$$ extends Augmentation<ActualEndpoints>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public ActualEndpointsBuilder withKey(ActualEndpointsKey key) {
        this.key = key;
        return this;
    }

    public ActualEndpointsBuilder setDataConfigEndpoints(List<DataConfigEndpoints> values) {
        this._dataConfigEndpoints = values;
        return this;
    }

    public ActualEndpointsBuilder setDataOperationalEndpoints(List<DataOperationalEndpoints> values) {
        this._dataOperationalEndpoints = values;
        return this;
    }

    public ActualEndpointsBuilder setModules(List<YangIdentifier> values) {
        this._modules = values;
        return this;
    }

    public ActualEndpointsBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public ActualEndpointsBuilder setNotificationEndpoints(List<NotificationEndpoints> values) {
        this._notificationEndpoints = values;
        return this;
    }

    public ActualEndpointsBuilder setRpcEndpoints(List<RpcEndpoints> values) {
        this._rpcEndpoints = values;
        return this;
    }

    public ActualEndpointsBuilder addAugmentation(Class<? extends Augmentation<ActualEndpoints>> augmentationType, Augmentation<ActualEndpoints> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ActualEndpoints>>, Augmentation<ActualEndpoints>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ActualEndpointsBuilder removeAugmentation(Class<? extends Augmentation<ActualEndpoints>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ActualEndpoints build() {
        return new ActualEndpointsImpl(this);
    }

    private static final class ActualEndpointsImpl
    implements ActualEndpoints {
        private final List<DataConfigEndpoints> _dataConfigEndpoints;
        private final List<DataOperationalEndpoints> _dataOperationalEndpoints;
        private final List<YangIdentifier> _modules;
        private final String _name;
        private final List<NotificationEndpoints> _notificationEndpoints;
        private final List<RpcEndpoints> _rpcEndpoints;
        private final ActualEndpointsKey key;
        private Map<Class<? extends Augmentation<ActualEndpoints>>, Augmentation<ActualEndpoints>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        ActualEndpointsImpl(ActualEndpointsBuilder base) {
            this.key = base.key() != null ? base.key() : new ActualEndpointsKey(base.getName());
            this._name = this.key.getName();
            this._dataConfigEndpoints = base.getDataConfigEndpoints();
            this._dataOperationalEndpoints = base.getDataOperationalEndpoints();
            this._modules = base.getModules();
            this._notificationEndpoints = base.getNotificationEndpoints();
            this._rpcEndpoints = base.getRpcEndpoints();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<ActualEndpoints> getImplementedInterface() {
            return ActualEndpoints.class;
        }

        @Override
        public ActualEndpointsKey key() {
            return this.key;
        }

        @Override
        public List<DataConfigEndpoints> getDataConfigEndpoints() {
            return this._dataConfigEndpoints;
        }

        @Override
        public List<DataOperationalEndpoints> getDataOperationalEndpoints() {
            return this._dataOperationalEndpoints;
        }

        @Override
        public List<YangIdentifier> getModules() {
            return this._modules;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public List<NotificationEndpoints> getNotificationEndpoints() {
            return this._notificationEndpoints;
        }

        @Override
        public List<RpcEndpoints> getRpcEndpoints() {
            return this._rpcEndpoints;
        }

        public <E$$ extends Augmentation<ActualEndpoints>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._dataConfigEndpoints);
            result = 31 * result + Objects.hashCode(this._dataOperationalEndpoints);
            result = 31 * result + Objects.hashCode(this._modules);
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._notificationEndpoints);
            result = 31 * result + Objects.hashCode(this._rpcEndpoints);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ActualEndpoints.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ActualEndpoints other = (ActualEndpoints)obj;
            if (!Objects.equals(this._dataConfigEndpoints, other.getDataConfigEndpoints())) {
                return false;
            }
            if (!Objects.equals(this._dataOperationalEndpoints, other.getDataOperationalEndpoints())) {
                return false;
            }
            if (!Objects.equals(this._modules, other.getModules())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._notificationEndpoints, other.getNotificationEndpoints())) {
                return false;
            }
            if (!Objects.equals(this._rpcEndpoints, other.getRpcEndpoints())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ActualEndpointsImpl otherImpl = (ActualEndpointsImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ActualEndpoints>>, Augmentation<ActualEndpoints>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"ActualEndpoints");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_dataConfigEndpoints", this._dataConfigEndpoints);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_dataOperationalEndpoints", this._dataOperationalEndpoints);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_modules", this._modules);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_name", (Object)this._name);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_notificationEndpoints", this._notificationEndpoints);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_rpcEndpoints", this._rpcEndpoints);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

