/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.Config;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.config.ActualEndpoints;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.config.ConfiguredEndpoints;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ConfigBuilder
implements Builder<Config> {
    private List<ActualEndpoints> _actualEndpoints;
    private List<ConfiguredEndpoints> _configuredEndpoints;
    private Uri _governanceRoot;
    private Uri _whoAmI;
    Map<Class<? extends Augmentation<Config>>, Augmentation<Config>> augmentation = Collections.emptyMap();

    public ConfigBuilder() {
    }

    public ConfigBuilder(Config base) {
        Map aug;
        this._actualEndpoints = base.getActualEndpoints();
        this._configuredEndpoints = base.getConfiguredEndpoints();
        this._governanceRoot = base.getGovernanceRoot();
        this._whoAmI = base.getWhoAmI();
        if (base instanceof ConfigImpl) {
            ConfigImpl impl = (ConfigImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>(aug);
        }
    }

    public List<ActualEndpoints> getActualEndpoints() {
        return this._actualEndpoints;
    }

    public List<ConfiguredEndpoints> getConfiguredEndpoints() {
        return this._configuredEndpoints;
    }

    public Uri getGovernanceRoot() {
        return this._governanceRoot;
    }

    public Uri getWhoAmI() {
        return this._whoAmI;
    }

    public <E$$ extends Augmentation<Config>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public ConfigBuilder setActualEndpoints(List<ActualEndpoints> values) {
        this._actualEndpoints = values;
        return this;
    }

    public ConfigBuilder setConfiguredEndpoints(List<ConfiguredEndpoints> values) {
        this._configuredEndpoints = values;
        return this;
    }

    public ConfigBuilder setGovernanceRoot(Uri value) {
        this._governanceRoot = value;
        return this;
    }

    public ConfigBuilder setWhoAmI(Uri value) {
        this._whoAmI = value;
        return this;
    }

    public ConfigBuilder addAugmentation(Class<? extends Augmentation<Config>> augmentationType, Augmentation<Config> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ConfigBuilder removeAugmentation(Class<? extends Augmentation<Config>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Config build() {
        return new ConfigImpl(this);
    }

    private static final class ConfigImpl
    implements Config {
        private final List<ActualEndpoints> _actualEndpoints;
        private final List<ConfiguredEndpoints> _configuredEndpoints;
        private final Uri _governanceRoot;
        private final Uri _whoAmI;
        private Map<Class<? extends Augmentation<Config>>, Augmentation<Config>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        ConfigImpl(ConfigBuilder base) {
            this._actualEndpoints = base.getActualEndpoints();
            this._configuredEndpoints = base.getConfiguredEndpoints();
            this._governanceRoot = base.getGovernanceRoot();
            this._whoAmI = base.getWhoAmI();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Config> getImplementedInterface() {
            return Config.class;
        }

        @Override
        public List<ActualEndpoints> getActualEndpoints() {
            return this._actualEndpoints;
        }

        @Override
        public List<ConfiguredEndpoints> getConfiguredEndpoints() {
            return this._configuredEndpoints;
        }

        @Override
        public Uri getGovernanceRoot() {
            return this._governanceRoot;
        }

        @Override
        public Uri getWhoAmI() {
            return this._whoAmI;
        }

        public <E$$ extends Augmentation<Config>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._actualEndpoints);
            result = 31 * result + Objects.hashCode(this._configuredEndpoints);
            result = 31 * result + Objects.hashCode(this._governanceRoot);
            result = 31 * result + Objects.hashCode(this._whoAmI);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Config.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Config other = (Config)obj;
            if (!Objects.equals(this._actualEndpoints, other.getActualEndpoints())) {
                return false;
            }
            if (!Objects.equals(this._configuredEndpoints, other.getConfiguredEndpoints())) {
                return false;
            }
            if (!Objects.equals(this._governanceRoot, other.getGovernanceRoot())) {
                return false;
            }
            if (!Objects.equals(this._whoAmI, other.getWhoAmI())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ConfigImpl otherImpl = (ConfigImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Config>>, Augmentation<Config>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Config");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_actualEndpoints", this._actualEndpoints);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_configuredEndpoints", this._configuredEndpoints);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_governanceRoot", (Object)this._governanceRoot);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_whoAmI", (Object)this._whoAmI);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

