/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.jsonrpc;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcReplyMessage;

public class JsonRpcReplyMessageSerializer
implements JsonSerializer<JsonRpcReplyMessage> {
    public JsonElement serialize(JsonRpcReplyMessage src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject obj = new JsonObject();
        obj.addProperty("jsonrpc", src.getJsonrpc());
        obj.add("id", src.getId());
        if (src.getError() != null) {
            JsonObject err = new JsonObject();
            err.addProperty("code", (Number)src.getError().getCode());
            err.addProperty("message", src.getError().getMessage());
            if (src.getError().getData() != null) {
                err.add("data", src.getError().getData());
            }
            obj.add("error", (JsonElement)err);
        }
        if (src.getResult() != null) {
            obj.add("result", src.getResult());
        }
        if (src.getMetadata() != null) {
            obj.add("metadata", (JsonElement)src.getMetadata());
        }
        return obj;
    }
}

