/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.jsonrpc;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcBaseMessage;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcErrorObject;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcException;

public final class JsonRpcReplyMessage
extends JsonRpcBaseMessage {
    private final JsonElement result;
    private final JsonRpcErrorObject error;

    private JsonRpcReplyMessage(Builder builder) {
        super(builder);
        this.result = builder.result;
        this.error = builder.error;
    }

    public boolean isResult() {
        return this.result != null;
    }

    public boolean isError() {
        return this.error != null;
    }

    @Nullable
    public JsonElement getResult() {
        return this.result;
    }

    public <T> T getResultAsObject(Type type) throws JsonRpcException {
        return JsonRpcReplyMessage.convertJsonElementToClass(this.getResult(), type);
    }

    @Nullable
    public JsonRpcErrorObject getError() {
        return this.error;
    }

    @Override
    public JsonRpcBaseMessage.JsonRpcMessageType getType() {
        return JsonRpcBaseMessage.JsonRpcMessageType.REPLY;
    }

    public String toString() {
        return "JsonRpcReplyMessage [jsonrpc=" + this.getJsonrpc() + ", id=" + this.getId() + ",result=" + this.result + ", error=" + this.error + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends JsonRpcBaseMessage.AbstractBuilder<Builder, JsonRpcReplyMessage> {
        private JsonElement result;
        private JsonRpcErrorObject error;

        public Builder result(JsonElement value) {
            this.result = value;
            return this;
        }

        public Builder resultFromObject(Object obj) {
            return this.result(JsonRpcBaseMessage.convertClassToJsonElement(obj));
        }

        public Builder error(JsonRpcErrorObject value) {
            this.error = value;
            return this;
        }

        @Override
        protected JsonRpcReplyMessage newInstance() {
            if (this.result != null && this.error != null) {
                throw new IllegalArgumentException("Both result and error defined");
            }
            if (this.result == null && this.error == null) {
                this.result((JsonElement)new JsonObject());
            }
            return new JsonRpcReplyMessage(this);
        }
    }
}

