/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.jsonrpc;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JsonRpcBaseMessage {
    private static final Logger LOG = LoggerFactory.getLogger(JsonRpcBaseMessage.class);
    private static final Gson GSON = new Gson();
    protected static final String VERSION = "2.0";
    protected static final String VERSION_SHORT = "2";
    private final String jsonrpc;
    private final JsonElement id;
    private final JsonObject metadata;

    protected JsonRpcBaseMessage(AbstractBuilder<?, ?> builder) {
        this.jsonrpc = Objects.requireNonNull(((AbstractBuilder)builder).jsonrpc);
        this.id = ((AbstractBuilder)builder).id;
        this.metadata = ((AbstractBuilder)builder).metadata;
    }

    @Nonnull
    public String getJsonrpc() {
        return this.jsonrpc;
    }

    @Nullable
    public JsonObject getMetadata() {
        return this.metadata;
    }

    @Nullable
    public JsonElement getId() {
        return this.id;
    }

    public int getIdAsIntValue() {
        try {
            return this.getId().getAsJsonPrimitive().getAsNumber().intValue();
        }
        catch (RuntimeException e) {
            LOG.debug("Unable to parse ID as int", (Throwable)e);
            return 0;
        }
    }

    protected static <T> T convertJsonElementToClass(JsonElement elem, Type type) throws JsonRpcException {
        try {
            return (T)GSON.fromJson(GSON.toJson(elem), type);
        }
        catch (RuntimeException e) {
            throw new JsonRpcException(e);
        }
    }

    protected static JsonElement convertClassToJsonElement(Object obj) {
        if (JsonElement.class.isInstance(obj)) {
            return (JsonElement)obj;
        }
        return (JsonElement)GSON.fromJson(GSON.toJson(obj), JsonElement.class);
    }

    public static String getSupportedVersion() {
        return VERSION;
    }

    public static boolean isSupportedVersion(String version) {
        return VERSION.equals(version) || VERSION_SHORT.equals(version);
    }

    @Nonnull
    public abstract JsonRpcMessageType getType();

    protected static abstract class AbstractBuilder<T extends AbstractBuilder<T, M>, M extends JsonRpcBaseMessage> {
        private String jsonrpc = "2.0";
        private JsonElement id;
        private JsonObject metadata;

        protected AbstractBuilder() {
        }

        protected T self() {
            return (T)this;
        }

        public T jsonrpc(String value) {
            this.jsonrpc = value;
            return this.self();
        }

        public T id(JsonElement value) {
            this.id = value;
            return this.self();
        }

        public T idFromIntValue(int value) {
            return this.id((JsonElement)new JsonPrimitive((Number)value));
        }

        public T metadata(JsonObject value) {
            this.metadata = value;
            return this.self();
        }

        public final M build() {
            return this.newInstance();
        }

        protected abstract M newInstance();
    }

    public static enum JsonRpcMessageType {
        REQUEST,
        NOTIFICATION,
        REPLY,
        PARSE_ERROR;

    }
}

