/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.pool.narayana.impl;

import java.sql.SQLException;
import java.util.Properties;
import java.util.UUID;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.commons.dbcp2.PoolableConnection;
import org.apache.commons.dbcp2.managed.DataSourceXAConnectionFactory;
import org.apache.commons.dbcp2.managed.ManagedDataSource;
import org.apache.commons.dbcp2.managed.PoolableManagedConnectionFactory;
import org.apache.commons.dbcp2.managed.TransactionRegistry;
import org.apache.commons.dbcp2.managed.XAConnectionFactory;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.jboss.tm.XAResourceRecovery;
import org.ops4j.pax.jdbc.common.BeanConfig;
import org.ops4j.pax.jdbc.pool.narayana.impl.DbcpPooledDataSourceFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.jdbc.DataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbcpXAPooledDataSourceFactory
extends DbcpPooledDataSourceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DbcpXAPooledDataSourceFactory.class);
    protected final TransactionManager tm;
    protected final BundleContext bundleContext;

    public DbcpXAPooledDataSourceFactory(BundleContext bundleContext, TransactionManager tm) {
        this.bundleContext = bundleContext;
        this.tm = tm;
    }

    @Override
    protected ObjectName getJmxName(String dsName) {
        if (dsName == null) {
            dsName = UUID.randomUUID().toString();
        }
        try {
            return new ObjectName("org.ops4j.pax.jdbc.pool", "dsName", dsName);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Invalid object name for data source" + dsName, e);
        }
    }

    @Override
    public DataSource create(DataSourceFactory dsf, Properties props) throws SQLException {
        try {
            final XADataSource ds = dsf.createXADataSource(this.getNonPoolProps(props));
            DataSourceXAConnectionFactory connFactory = new DataSourceXAConnectionFactory(this.tm, ds);
            PoolableManagedConnectionFactory pcf = new PoolableManagedConnectionFactory((XAConnectionFactory)connFactory, null);
            GenericObjectPoolConfig conf = new GenericObjectPoolConfig();
            BeanConfig.configure((Object)conf, this.getPoolProps(props));
            BeanConfig.configure((Object)pcf, this.getPrefixed(props, "factory."));
            GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)pcf, conf);
            pcf.setPool((ObjectPool)pool);
            TransactionRegistry transactionRegistry = connFactory.getTransactionRegistry();
            final ServiceRegistration registration = this.bundleContext.registerService(XAResourceRecovery.class, (Object)new XAResourceRecovery(){

                public XAResource[] getXAResources() {
                    try {
                        return new XAResource[]{new Wrapper(ds.getXAConnection())};
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
            }, null);
            ManagedDataSource<PoolableConnection> mds = new ManagedDataSource<PoolableConnection>((ObjectPool)pool, transactionRegistry){

                public void close() throws Exception {
                    registration.unregister();
                    super.close();
                }
            };
            return mds;
        }
        catch (Throwable e) {
            LOG.error("Error creating pooled datasource: " + e.getMessage(), e);
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    class Wrapper
    implements XAResource {
        private final XAConnection xaConnection;
        private final XAResource xaResource;

        Wrapper(XAConnection xaConnection) throws SQLException {
            this.xaConnection = xaConnection;
            this.xaResource = xaConnection.getXAResource();
        }

        @Override
        public void commit(Xid xid, boolean b) throws XAException {
            this.xaResource.commit(xid, b);
        }

        @Override
        public void end(Xid xid, int i) throws XAException {
            this.xaResource.end(xid, i);
        }

        @Override
        public void forget(Xid xid) throws XAException {
            this.xaResource.forget(xid);
        }

        @Override
        public int getTransactionTimeout() throws XAException {
            return this.xaResource.getTransactionTimeout();
        }

        @Override
        public boolean isSameRM(XAResource xaResource) throws XAException {
            return this.xaResource.isSameRM(xaResource);
        }

        @Override
        public int prepare(Xid xid) throws XAException {
            return this.xaResource.prepare(xid);
        }

        @Override
        public Xid[] recover(int i) throws XAException {
            if (i == 0x800000) {
                try {
                    this.xaConnection.close();
                    return null;
                }
                catch (SQLException e) {
                    throw (XAException)new XAException(-3).initCause(e);
                }
            }
            return this.xaResource.recover(i);
        }

        @Override
        public void rollback(Xid xid) throws XAException {
            this.xaResource.rollback(xid);
        }

        @Override
        public boolean setTransactionTimeout(int i) throws XAException {
            return this.xaResource.setTransactionTimeout(i);
        }

        @Override
        public void start(Xid xid, int i) throws XAException {
            this.xaResource.start(xid, i);
        }
    }
}

