/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft.messages;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.opendaylight.controller.cluster.raft.messages.AbstractRaftRPC;

public final class RequestVoteReply
extends AbstractRaftRPC {
    private static final long serialVersionUID = 8427899326488775660L;
    private final boolean voteGranted;

    public RequestVoteReply(long term, boolean voteGranted) {
        super(term);
        this.voteGranted = voteGranted;
    }

    public boolean isVoteGranted() {
        return this.voteGranted;
    }

    public String toString() {
        return "RequestVoteReply [term=" + this.getTerm() + ", voteGranted=" + this.voteGranted + "]";
    }

    private Object writeReplace() {
        return new Proxy(this);
    }

    private static class Proxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private RequestVoteReply requestVoteReply;

        public Proxy() {
        }

        Proxy(RequestVoteReply requestVoteReply) {
            this.requestVoteReply = requestVoteReply;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeLong(this.requestVoteReply.getTerm());
            out.writeBoolean(this.requestVoteReply.voteGranted);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException {
            long term = in.readLong();
            boolean voteGranted = in.readBoolean();
            this.requestVoteReply = new RequestVoteReply(term, voteGranted);
        }

        private Object readResolve() {
            return this.requestVoteReply;
        }
    }
}

