/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft.behaviors;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import java.util.ArrayList;
import java.util.Collection;
import org.opendaylight.controller.cluster.raft.PeerInfo;
import org.opendaylight.controller.cluster.raft.RaftActorContext;
import org.opendaylight.controller.cluster.raft.RaftState;
import org.opendaylight.controller.cluster.raft.base.messages.ElectionTimeout;
import org.opendaylight.controller.cluster.raft.behaviors.AbstractRaftActorBehavior;
import org.opendaylight.controller.cluster.raft.behaviors.Follower;
import org.opendaylight.controller.cluster.raft.behaviors.RaftActorBehavior;
import org.opendaylight.controller.cluster.raft.messages.AppendEntries;
import org.opendaylight.controller.cluster.raft.messages.AppendEntriesReply;
import org.opendaylight.controller.cluster.raft.messages.RaftRPC;
import org.opendaylight.controller.cluster.raft.messages.RequestVote;
import org.opendaylight.controller.cluster.raft.messages.RequestVoteReply;
import scala.concurrent.duration.FiniteDuration;

public class Candidate
extends AbstractRaftActorBehavior {
    private int voteCount;
    private final int votesRequired;
    private final Collection<String> votingPeers = new ArrayList<String>();

    public Candidate(RaftActorContext context) {
        super(context, RaftState.Candidate);
        for (PeerInfo peer : context.getPeers()) {
            if (!peer.isVoting()) continue;
            this.votingPeers.add(peer.getId());
        }
        this.log.debug("{}: Election: Candidate has following voting peers: {}", (Object)this.logName(), this.votingPeers);
        this.votesRequired = this.getMajorityVoteCount(this.votingPeers.size());
        this.startNewTerm();
        if (this.votingPeers.isEmpty()) {
            this.actor().tell((Object)ElectionTimeout.INSTANCE, this.actor());
        } else {
            this.scheduleElection(this.electionDuration());
        }
    }

    @Override
    public final String getLeaderId() {
        return null;
    }

    @Override
    public final short getLeaderPayloadVersion() {
        return -1;
    }

    @Override
    protected RaftActorBehavior handleAppendEntries(ActorRef sender, AppendEntries appendEntries) {
        this.log.debug("{}: handleAppendEntries: {}", (Object)this.logName(), (Object)appendEntries);
        if (this.currentTerm() == appendEntries.getTerm()) {
            this.log.info("{}: New Leader {} sent an AppendEntries to Candidate for term {} - will switch to Follower", new Object[]{this.logName(), appendEntries.getLeaderId(), this.currentTerm()});
            return this.switchBehavior(new Follower(this.context));
        }
        return this;
    }

    @Override
    protected RaftActorBehavior handleAppendEntriesReply(ActorRef sender, AppendEntriesReply appendEntriesReply) {
        return this;
    }

    @Override
    protected RaftActorBehavior handleRequestVoteReply(ActorRef sender, RequestVoteReply requestVoteReply) {
        this.log.debug("{}: handleRequestVoteReply: {}, current voteCount: {}", new Object[]{this.logName(), requestVoteReply, this.voteCount});
        if (requestVoteReply.isVoteGranted()) {
            ++this.voteCount;
        }
        if (this.voteCount >= this.votesRequired) {
            if (this.context.getLastApplied() < this.context.getReplicatedLog().lastIndex()) {
                this.log.info("{}: LastApplied index {} is behind last index {} - switching to PreLeader", new Object[]{this.logName(), this.context.getLastApplied(), this.context.getReplicatedLog().lastIndex()});
                return this.internalSwitchBehavior(RaftState.PreLeader);
            }
            return this.internalSwitchBehavior(RaftState.Leader);
        }
        return this;
    }

    @Override
    protected FiniteDuration electionDuration() {
        return super.electionDuration().$div(this.context.getConfigParams().getCandidateElectionTimeoutDivisor());
    }

    @Override
    public RaftActorBehavior handleMessage(ActorRef sender, Object message) {
        if (message instanceof ElectionTimeout) {
            this.log.debug("{}: Received ElectionTimeout", (Object)this.logName());
            if (this.votesRequired == 0) {
                return this.internalSwitchBehavior(RaftState.Leader);
            }
            this.startNewTerm();
            this.scheduleElection(this.electionDuration());
            return this;
        }
        if (message instanceof RaftRPC) {
            RaftRPC rpc = (RaftRPC)message;
            this.log.debug("{}: RaftRPC message received {}, my term is {}", new Object[]{this.logName(), rpc, this.context.getTermInformation().getCurrentTerm()});
            if (rpc.getTerm() > this.context.getTermInformation().getCurrentTerm()) {
                this.log.info("{}: Term {} in \"{}\" message is greater than Candidate's term {} - switching to Follower", new Object[]{this.logName(), rpc.getTerm(), rpc, this.context.getTermInformation().getCurrentTerm()});
                this.context.getTermInformation().updateAndPersist(rpc.getTerm(), null);
                if (message instanceof RequestVote) {
                    super.handleMessage(sender, message);
                }
                return this.internalSwitchBehavior(RaftState.Follower);
            }
        }
        return super.handleMessage(sender, message);
    }

    private void startNewTerm() {
        this.voteCount = 1;
        long currentTerm = this.context.getTermInformation().getCurrentTerm();
        long newTerm = currentTerm + 1L;
        this.context.getTermInformation().updateAndPersist(newTerm, this.context.getId());
        this.log.info("{}: Starting new election term {}", (Object)this.logName(), (Object)newTerm);
        for (String peerId : this.votingPeers) {
            ActorSelection peerActor = this.context.getPeerActorSelection(peerId);
            if (peerActor == null) continue;
            RequestVote requestVote = new RequestVote(this.context.getTermInformation().getCurrentTerm(), this.context.getId(), this.context.getReplicatedLog().lastIndex(), this.context.getReplicatedLog().lastTerm());
            this.log.debug("{}: Sending {} to peer {}", new Object[]{this.logName(), requestVote, peerId});
            peerActor.tell((Object)requestVote, this.context.getActor());
        }
    }

    @Override
    public void close() {
        this.stopElection();
    }
}

