/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft.behaviors;

import akka.actor.ActorRef;
import akka.actor.Cancellable;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.opendaylight.controller.cluster.raft.ClientRequestTracker;
import org.opendaylight.controller.cluster.raft.RaftActorContext;
import org.opendaylight.controller.cluster.raft.RaftState;
import org.opendaylight.controller.cluster.raft.ReplicatedLogEntry;
import org.opendaylight.controller.cluster.raft.base.messages.ApplyState;
import org.opendaylight.controller.cluster.raft.base.messages.ElectionTimeout;
import org.opendaylight.controller.cluster.raft.behaviors.Candidate;
import org.opendaylight.controller.cluster.raft.behaviors.Follower;
import org.opendaylight.controller.cluster.raft.behaviors.IsolatedLeader;
import org.opendaylight.controller.cluster.raft.behaviors.Leader;
import org.opendaylight.controller.cluster.raft.behaviors.PreLeader;
import org.opendaylight.controller.cluster.raft.behaviors.RaftActorBehavior;
import org.opendaylight.controller.cluster.raft.messages.AppendEntries;
import org.opendaylight.controller.cluster.raft.messages.AppendEntriesReply;
import org.opendaylight.controller.cluster.raft.messages.RequestVote;
import org.opendaylight.controller.cluster.raft.messages.RequestVoteReply;
import org.opendaylight.controller.cluster.raft.persisted.ApplyJournalEntries;
import org.slf4j.Logger;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;

public abstract class AbstractRaftActorBehavior
implements RaftActorBehavior {
    protected final RaftActorContext context;
    @SuppressFBWarnings(value={"SLF4J_LOGGER_SHOULD_BE_PRIVATE"})
    protected final Logger log;
    private final String logName;
    private final RaftState state;
    private Cancellable electionCancel = null;
    private long replicatedToAllIndex = -1L;

    AbstractRaftActorBehavior(RaftActorContext context, RaftState state) {
        this.context = (RaftActorContext)Preconditions.checkNotNull((Object)context);
        this.state = (RaftState)((Object)Preconditions.checkNotNull((Object)((Object)state)));
        this.log = context.getLogger();
        this.logName = String.format("%s (%s)", new Object[]{context.getId(), state});
    }

    public static RaftActorBehavior createBehavior(RaftActorContext context, RaftState state) {
        switch (state) {
            case Candidate: {
                return new Candidate(context);
            }
            case Follower: {
                return new Follower(context);
            }
            case IsolatedLeader: {
                return new IsolatedLeader(context);
            }
            case Leader: {
                return new Leader(context);
            }
            case PreLeader: {
                return new PreLeader(context);
            }
        }
        throw new IllegalArgumentException("Unhandled state " + (Object)((Object)state));
    }

    @Override
    public final RaftState state() {
        return this.state;
    }

    protected final String logName() {
        return this.logName;
    }

    @Override
    public void setReplicatedToAllIndex(long replicatedToAllIndex) {
        this.replicatedToAllIndex = replicatedToAllIndex;
    }

    @Override
    public long getReplicatedToAllIndex() {
        return this.replicatedToAllIndex;
    }

    protected abstract RaftActorBehavior handleAppendEntries(ActorRef var1, AppendEntries var2);

    protected RaftActorBehavior appendEntries(ActorRef sender, AppendEntries appendEntries) {
        if (appendEntries.getTerm() < this.currentTerm()) {
            this.log.info("{}: Cannot append entries because sender's term {} is less than {}", new Object[]{this.logName(), appendEntries.getTerm(), this.currentTerm()});
            sender.tell((Object)new AppendEntriesReply(this.context.getId(), this.currentTerm(), false, this.lastIndex(), this.lastTerm(), this.context.getPayloadVersion(), false, false, appendEntries.getLeaderRaftVersion()), this.actor());
            return this;
        }
        return this.handleAppendEntries(sender, appendEntries);
    }

    protected abstract RaftActorBehavior handleAppendEntriesReply(ActorRef var1, AppendEntriesReply var2);

    protected RaftActorBehavior requestVote(ActorRef sender, RequestVote requestVote) {
        this.log.debug("{}: In requestVote:  {} - currentTerm: {}, votedFor: {}, lastIndex: {}, lastTerm: {}", new Object[]{this.logName(), requestVote, this.currentTerm(), this.votedFor(), this.lastIndex(), this.lastTerm()});
        boolean grantVote = this.canGrantVote(requestVote);
        if (grantVote) {
            this.context.getTermInformation().updateAndPersist(requestVote.getTerm(), requestVote.getCandidateId());
        }
        RequestVoteReply reply = new RequestVoteReply(this.currentTerm(), grantVote);
        this.log.debug("{}: requestVote returning: {}", (Object)this.logName(), (Object)reply);
        sender.tell((Object)reply, this.actor());
        return this;
    }

    protected boolean canGrantVote(RequestVote requestVote) {
        boolean grantVote = false;
        if (requestVote.getTerm() < this.currentTerm()) {
            grantVote = false;
        } else if (this.votedFor() == null || this.votedFor().equals(requestVote.getCandidateId())) {
            boolean candidateLatest = false;
            if (requestVote.getLastLogTerm() > this.lastTerm()) {
                candidateLatest = true;
            } else if (requestVote.getLastLogTerm() == this.lastTerm() && requestVote.getLastLogIndex() >= this.lastIndex()) {
                candidateLatest = true;
            }
            if (candidateLatest) {
                grantVote = true;
            }
        }
        return grantVote;
    }

    protected abstract RaftActorBehavior handleRequestVoteReply(ActorRef var1, RequestVoteReply var2);

    protected FiniteDuration electionDuration() {
        long variance = new Random().nextInt(this.context.getConfigParams().getElectionTimeVariance());
        return this.context.getConfigParams().getElectionTimeOutInterval().$plus(new FiniteDuration(variance, TimeUnit.MILLISECONDS));
    }

    protected void stopElection() {
        if (this.electionCancel != null && !this.electionCancel.isCancelled()) {
            this.electionCancel.cancel();
        }
    }

    protected boolean canStartElection() {
        return this.context.getRaftPolicy().automaticElectionsEnabled() && this.context.isVotingMember();
    }

    protected void scheduleElection(FiniteDuration interval) {
        this.stopElection();
        this.electionCancel = this.context.getActorSystem().scheduler().scheduleOnce(interval, this.context.getActor(), (Object)ElectionTimeout.INSTANCE, (ExecutionContext)this.context.getActorSystem().dispatcher(), this.context.getActor());
    }

    protected long currentTerm() {
        return this.context.getTermInformation().getCurrentTerm();
    }

    protected String votedFor() {
        return this.context.getTermInformation().getVotedFor();
    }

    protected ActorRef actor() {
        return this.context.getActor();
    }

    protected long lastTerm() {
        return this.context.getReplicatedLog().lastTerm();
    }

    protected long lastIndex() {
        return this.context.getReplicatedLog().lastIndex();
    }

    protected ClientRequestTracker removeClientRequestTracker(long logIndex) {
        return null;
    }

    protected long getLogEntryIndex(long index) {
        if (index == this.context.getReplicatedLog().getSnapshotIndex()) {
            return this.context.getReplicatedLog().getSnapshotIndex();
        }
        ReplicatedLogEntry entry = this.context.getReplicatedLog().get(index);
        if (entry != null) {
            return entry.getIndex();
        }
        return -1L;
    }

    protected long getLogEntryTerm(long index) {
        if (index == this.context.getReplicatedLog().getSnapshotIndex()) {
            return this.context.getReplicatedLog().getSnapshotTerm();
        }
        ReplicatedLogEntry entry = this.context.getReplicatedLog().get(index);
        if (entry != null) {
            return entry.getTerm();
        }
        return -1L;
    }

    protected long getLogEntryOrSnapshotTerm(long index) {
        if (this.context.getReplicatedLog().isInSnapshot(index)) {
            return this.context.getReplicatedLog().getSnapshotTerm();
        }
        return this.getLogEntryTerm(index);
    }

    protected void applyLogToStateMachine(long index) {
        for (long i = this.context.getLastApplied() + 1L; i < index + 1L; ++i) {
            ReplicatedLogEntry replicatedLogEntry = this.context.getReplicatedLog().get(i);
            if (replicatedLogEntry == null) {
                this.log.warn("{}: Missing index {} from log. Cannot apply state. Ignoring {} to {}", new Object[]{this.logName(), i, i, index});
                break;
            }
            ClientRequestTracker tracker = this.removeClientRequestTracker(i);
            ApplyState applyState = tracker != null ? new ApplyState(tracker.getClientActor(), tracker.getIdentifier(), replicatedLogEntry) : new ApplyState(null, null, replicatedLogEntry);
            this.log.debug("{}: Setting last applied to {}", (Object)this.logName(), (Object)i);
            this.context.setLastApplied(i);
            this.context.getApplyStateConsumer().accept(applyState);
        }
        this.actor().tell((Object)new ApplyJournalEntries(this.context.getLastApplied()), this.actor());
    }

    @Override
    public RaftActorBehavior handleMessage(ActorRef sender, Object message) {
        if (message instanceof AppendEntries) {
            return this.appendEntries(sender, (AppendEntries)message);
        }
        if (message instanceof AppendEntriesReply) {
            return this.handleAppendEntriesReply(sender, (AppendEntriesReply)message);
        }
        if (message instanceof RequestVote) {
            return this.requestVote(sender, (RequestVote)message);
        }
        if (message instanceof RequestVoteReply) {
            return this.handleRequestVoteReply(sender, (RequestVoteReply)message);
        }
        return null;
    }

    @Override
    public RaftActorBehavior switchBehavior(RaftActorBehavior behavior) {
        return this.internalSwitchBehavior(behavior);
    }

    protected RaftActorBehavior internalSwitchBehavior(RaftState newState) {
        return this.internalSwitchBehavior(AbstractRaftActorBehavior.createBehavior(this.context, newState));
    }

    protected RaftActorBehavior internalSwitchBehavior(RaftActorBehavior newBehavior) {
        if (!this.context.getRaftPolicy().automaticElectionsEnabled()) {
            return this;
        }
        this.log.info("{} :- Switching from behavior {} to {}, election term: {}", new Object[]{this.logName(), this.state(), newBehavior.state(), this.context.getTermInformation().getCurrentTerm()});
        try {
            this.close();
        }
        catch (RuntimeException e) {
            this.log.error("{}: Failed to close behavior : {}", new Object[]{this.logName(), this.state(), e});
        }
        return newBehavior;
    }

    protected int getMajorityVoteCount(int numPeers) {
        int numMajority = 0;
        if (numPeers > 0) {
            int self = 1;
            numMajority = (numPeers + self) / 2 + 1;
        }
        return numMajority;
    }

    protected void performSnapshotWithoutCapture(long snapshotCapturedIndex) {
        long actualIndex = this.context.getSnapshotManager().trimLog(snapshotCapturedIndex);
        if (actualIndex != -1L) {
            this.setReplicatedToAllIndex(actualIndex);
        }
    }

    protected String getId() {
        return this.context.getId();
    }
}

