/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft;

import akka.japi.Procedure;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.opendaylight.controller.cluster.raft.AbstractReplicatedLogImpl;
import org.opendaylight.controller.cluster.raft.ConfigParams;
import org.opendaylight.controller.cluster.raft.NoopProcedure;
import org.opendaylight.controller.cluster.raft.RaftActorContext;
import org.opendaylight.controller.cluster.raft.ReplicatedLog;
import org.opendaylight.controller.cluster.raft.ReplicatedLogEntry;
import org.opendaylight.controller.cluster.raft.persisted.DeleteEntries;
import org.opendaylight.controller.cluster.raft.persisted.Snapshot;

final class ReplicatedLogImpl
extends AbstractReplicatedLogImpl {
    private static final int DATA_SIZE_DIVIDER = 5;
    private final RaftActorContext context;
    private long dataSizeSinceLastSnapshot = 0L;

    private ReplicatedLogImpl(long snapshotIndex, long snapshotTerm, List<ReplicatedLogEntry> unAppliedEntries, RaftActorContext context) {
        super(snapshotIndex, snapshotTerm, unAppliedEntries, context.getId());
        this.context = Objects.requireNonNull(context);
    }

    static ReplicatedLog newInstance(Snapshot snapshot, RaftActorContext context) {
        return new ReplicatedLogImpl(snapshot.getLastAppliedIndex(), snapshot.getLastAppliedTerm(), snapshot.getUnAppliedEntries(), context);
    }

    static ReplicatedLog newInstance(RaftActorContext context) {
        return new ReplicatedLogImpl(-1L, -1L, Collections.emptyList(), context);
    }

    @Override
    public boolean removeFromAndPersist(long logEntryIndex) {
        long adjustedIndex = this.removeFrom(logEntryIndex);
        if (adjustedIndex >= 0L) {
            this.context.getPersistenceProvider().persist((Object)new DeleteEntries(adjustedIndex), NoopProcedure.instance());
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldCaptureSnapshot(long logIndex) {
        ConfigParams config = this.context.getConfigParams();
        long journalSize = logIndex + 1L;
        long dataThreshold = this.context.getTotalMemory() * (long)config.getSnapshotDataThresholdPercentage() / 100L;
        return journalSize % config.getSnapshotBatchCount() == 0L || this.getDataSizeForSnapshotCheck() > dataThreshold;
    }

    @Override
    public void captureSnapshotIfReady(ReplicatedLogEntry replicatedLogEntry) {
        boolean started;
        if (this.shouldCaptureSnapshot(replicatedLogEntry.getIndex()) && (started = this.context.getSnapshotManager().capture(replicatedLogEntry, this.context.getCurrentBehavior().getReplicatedToAllIndex())) && !this.context.hasFollowers()) {
            this.dataSizeSinceLastSnapshot = 0L;
        }
    }

    private long getDataSizeForSnapshotCheck() {
        if (!this.context.hasFollowers()) {
            return this.dataSizeSinceLastSnapshot / 5L;
        }
        return this.dataSize();
    }

    @Override
    public boolean appendAndPersist(ReplicatedLogEntry replicatedLogEntry, Procedure<ReplicatedLogEntry> callback, boolean doAsync) {
        this.context.getLogger().debug("{}: Append log entry and persist {} ", (Object)this.context.getId(), (Object)replicatedLogEntry);
        if (!this.append(replicatedLogEntry)) {
            return false;
        }
        if (doAsync) {
            this.context.getPersistenceProvider().persistAsync((Object)replicatedLogEntry, entry -> this.persistCallback((ReplicatedLogEntry)entry, callback));
        } else {
            this.context.getPersistenceProvider().persist((Object)replicatedLogEntry, entry -> this.syncPersistCallback((ReplicatedLogEntry)entry, callback));
        }
        return true;
    }

    private void persistCallback(ReplicatedLogEntry persistedLogEntry, Procedure<ReplicatedLogEntry> callback) {
        this.context.getExecutor().execute(() -> this.syncPersistCallback(persistedLogEntry, callback));
    }

    private void syncPersistCallback(ReplicatedLogEntry persistedLogEntry, Procedure<ReplicatedLogEntry> callback) {
        this.context.getLogger().debug("{}: persist complete {}", (Object)this.context.getId(), (Object)persistedLogEntry);
        this.dataSizeSinceLastSnapshot += (long)persistedLogEntry.size();
        if (callback != null) {
            try {
                callback.apply((Object)persistedLogEntry);
            }
            catch (Exception e) {
                this.context.getLogger().error("{}: persist callback failed", (Object)this.context.getId(), (Object)e);
                throw new IllegalStateException("Persist callback failed", e);
            }
        }
    }
}

