/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.raft.ConfigParams;
import org.opendaylight.controller.cluster.raft.NoopPeerAddressResolver;
import org.opendaylight.controller.cluster.raft.PeerAddressResolver;
import org.opendaylight.controller.cluster.raft.policy.DefaultRaftPolicy;
import org.opendaylight.controller.cluster.raft.policy.RaftPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.duration.FiniteDuration;

public class DefaultConfigParamsImpl
implements ConfigParams {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultConfigParamsImpl.class);
    private static final int SNAPSHOT_BATCH_COUNT = 20000;
    private static final int JOURNAL_RECOVERY_LOG_BATCH_SIZE = 1000;
    private static final int ELECTION_TIME_MAX_VARIANCE = 100;
    private static final int SNAPSHOT_CHUNK_SIZE = 2048000;
    public static final FiniteDuration HEART_BEAT_INTERVAL = new FiniteDuration(100L, TimeUnit.MILLISECONDS);
    private final Supplier<RaftPolicy> policySupplier = Suppliers.memoize(this::getPolicy);
    private FiniteDuration heartBeatInterval = HEART_BEAT_INTERVAL;
    private long snapshotBatchCount = 20000L;
    private int journalRecoveryLogBatchSize = 1000;
    private long isolatedLeaderCheckInterval = HEART_BEAT_INTERVAL.$times(1000L).toMillis();
    private FiniteDuration electionTimeOutInterval;
    private int snapshotDataThresholdPercentage = 12;
    private int snapshotChunkSize = 2048000;
    private long electionTimeoutFactor = 2L;
    private long candidateElectionTimeoutDivisor = 1L;
    private String customRaftPolicyImplementationClass;
    private PeerAddressResolver peerAddressResolver = NoopPeerAddressResolver.INSTANCE;
    private String tempFileDirectory = "";
    private int fileBackedStreamingThreshold = 0x8000000;
    private long syncIndexThreshold = 10L;

    public void setHeartBeatInterval(FiniteDuration heartBeatInterval) {
        this.heartBeatInterval = heartBeatInterval;
        this.electionTimeOutInterval = null;
    }

    public void setSnapshotBatchCount(long snapshotBatchCount) {
        this.snapshotBatchCount = snapshotBatchCount;
    }

    public void setSnapshotDataThresholdPercentage(int snapshotDataThresholdPercentage) {
        this.snapshotDataThresholdPercentage = snapshotDataThresholdPercentage;
    }

    public void setSnapshotChunkSize(int snapshotChunkSize) {
        this.snapshotChunkSize = snapshotChunkSize;
    }

    public void setJournalRecoveryLogBatchSize(int journalRecoveryLogBatchSize) {
        this.journalRecoveryLogBatchSize = journalRecoveryLogBatchSize;
    }

    public void setIsolatedLeaderCheckInterval(FiniteDuration isolatedLeaderCheckInterval) {
        this.isolatedLeaderCheckInterval = isolatedLeaderCheckInterval.toMillis();
    }

    public void setElectionTimeoutFactor(long electionTimeoutFactor) {
        this.electionTimeoutFactor = electionTimeoutFactor;
        this.electionTimeOutInterval = null;
    }

    public void setCandidateElectionTimeoutDivisor(long candidateElectionTimeoutDivisor) {
        this.candidateElectionTimeoutDivisor = candidateElectionTimeoutDivisor;
    }

    public void setTempFileDirectory(String tempFileDirectory) {
        this.tempFileDirectory = tempFileDirectory;
    }

    public void setFileBackedStreamingThreshold(int fileBackedStreamingThreshold) {
        this.fileBackedStreamingThreshold = fileBackedStreamingThreshold;
    }

    public void setCustomRaftPolicyImplementationClass(String customRaftPolicyImplementationClass) {
        this.customRaftPolicyImplementationClass = customRaftPolicyImplementationClass;
    }

    @Override
    public String getCustomRaftPolicyImplementationClass() {
        return this.customRaftPolicyImplementationClass;
    }

    @Override
    public long getSnapshotBatchCount() {
        return this.snapshotBatchCount;
    }

    @Override
    public int getSnapshotDataThresholdPercentage() {
        return this.snapshotDataThresholdPercentage;
    }

    @Override
    public FiniteDuration getHeartBeatInterval() {
        return this.heartBeatInterval;
    }

    @Override
    public FiniteDuration getElectionTimeOutInterval() {
        if (this.electionTimeOutInterval == null) {
            this.electionTimeOutInterval = this.getHeartBeatInterval().$times(this.electionTimeoutFactor);
        }
        return this.electionTimeOutInterval;
    }

    @Override
    public long getCandidateElectionTimeoutDivisor() {
        return this.candidateElectionTimeoutDivisor;
    }

    @Override
    public int getElectionTimeVariance() {
        return 100;
    }

    @Override
    public int getSnapshotChunkSize() {
        return this.snapshotChunkSize;
    }

    @Override
    public int getJournalRecoveryLogBatchSize() {
        return this.journalRecoveryLogBatchSize;
    }

    @Override
    public long getIsolatedCheckIntervalInMillis() {
        return this.isolatedLeaderCheckInterval;
    }

    @Override
    public long getElectionTimeoutFactor() {
        return this.electionTimeoutFactor;
    }

    @Override
    public RaftPolicy getRaftPolicy() {
        return (RaftPolicy)this.policySupplier.get();
    }

    @Override
    public String getTempFileDirectory() {
        return this.tempFileDirectory;
    }

    @Override
    public int getFileBackedStreamingThreshold() {
        return this.fileBackedStreamingThreshold;
    }

    @Override
    public PeerAddressResolver getPeerAddressResolver() {
        return this.peerAddressResolver;
    }

    public void setPeerAddressResolver(@NonNull PeerAddressResolver peerAddressResolver) {
        this.peerAddressResolver = Objects.requireNonNull(peerAddressResolver);
    }

    @Override
    public long getSyncIndexThreshold() {
        return this.syncIndexThreshold;
    }

    public void setSyncIndexThreshold(long syncIndexThreshold) {
        Preconditions.checkArgument((syncIndexThreshold >= 0L ? 1 : 0) != 0);
        this.syncIndexThreshold = syncIndexThreshold;
    }

    private RaftPolicy getPolicy() {
        if (Strings.isNullOrEmpty((String)this.customRaftPolicyImplementationClass)) {
            LOG.debug("No custom RaftPolicy specified. Using DefaultRaftPolicy");
            return DefaultRaftPolicy.INSTANCE;
        }
        try {
            String className = this.customRaftPolicyImplementationClass;
            LOG.info("Trying to use custom RaftPolicy {}", (Object)className);
            return (RaftPolicy)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassCastException | ReflectiveOperationException e) {
            if (LOG.isDebugEnabled()) {
                LOG.error("Could not create custom raft policy, will stick with default", (Throwable)e);
            } else {
                LOG.error("Could not create custom raft policy, will stick with default : cause = {}", (Object)e.getMessage());
            }
            return DefaultRaftPolicy.INSTANCE;
        }
    }
}

