/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.api;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

public abstract class DOMRpcIdentifier {
    private final SchemaPath type;

    private DOMRpcIdentifier(SchemaPath type) {
        this.type = Objects.requireNonNull(type);
    }

    public static @NonNull DOMRpcIdentifier create(@NonNull SchemaPath type) {
        return new Global(type);
    }

    public static @NonNull DOMRpcIdentifier create(@NonNull SchemaPath type, @Nullable YangInstanceIdentifier contextReference) {
        if (contextReference == null || contextReference.isEmpty()) {
            return new Global(type);
        }
        return new Local(type, contextReference);
    }

    public static DOMRpcIdentifier fromMdsal(org.opendaylight.mdsal.dom.api.DOMRpcIdentifier mdsal) {
        return DOMRpcIdentifier.create(mdsal.getType(), mdsal.getContextReference());
    }

    public org.opendaylight.mdsal.dom.api.DOMRpcIdentifier toMdsal() {
        return org.opendaylight.mdsal.dom.api.DOMRpcIdentifier.create((SchemaPath)this.type, (YangInstanceIdentifier)this.getContextReference());
    }

    public final @NonNull SchemaPath getType() {
        return this.type;
    }

    public abstract @NonNull YangInstanceIdentifier getContextReference();

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.getContextReference().hashCode();
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DOMRpcIdentifier)) {
            return false;
        }
        DOMRpcIdentifier other = (DOMRpcIdentifier)obj;
        if (!this.type.equals((Object)other.type)) {
            return false;
        }
        return Objects.equals(this.getContextReference(), other.getContextReference());
    }

    public final String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("type", (Object)this.type).add("contextReference", (Object)this.getContextReference()).toString();
    }

    private static final class Local
    extends DOMRpcIdentifier {
        private final YangInstanceIdentifier contextReference;

        private Local(@NonNull SchemaPath type, @NonNull YangInstanceIdentifier contextReference) {
            super(type);
            this.contextReference = Objects.requireNonNull(contextReference);
        }

        @Override
        public YangInstanceIdentifier getContextReference() {
            return this.contextReference;
        }
    }

    private static final class Global
    extends DOMRpcIdentifier {
        private Global(@NonNull SchemaPath type) {
            super(type);
        }

        @Override
        public YangInstanceIdentifier getContextReference() {
            return YangInstanceIdentifier.EMPTY;
        }
    }
}

