/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.api;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.concepts.Path;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

public final class DOMDataTreeIdentifier
implements Immutable,
Path<DOMDataTreeIdentifier>,
Serializable,
Comparable<DOMDataTreeIdentifier> {
    private static final long serialVersionUID = 1L;
    private final @NonNull YangInstanceIdentifier rootIdentifier;
    private final @NonNull LogicalDatastoreType datastoreType;

    public DOMDataTreeIdentifier(LogicalDatastoreType datastoreType, YangInstanceIdentifier rootIdentifier) {
        this.datastoreType = Objects.requireNonNull(datastoreType);
        this.rootIdentifier = Objects.requireNonNull(rootIdentifier);
    }

    public static DOMDataTreeIdentifier fromMdsal(org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier mdsal) {
        return new DOMDataTreeIdentifier(LogicalDatastoreType.fromMdsal((org.opendaylight.mdsal.common.api.LogicalDatastoreType)mdsal.getDatastoreType()), mdsal.getRootIdentifier());
    }

    public org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier toMdsal() {
        return new org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier(this.datastoreType.toMdsal(), this.rootIdentifier);
    }

    public @NonNull LogicalDatastoreType getDatastoreType() {
        return this.datastoreType;
    }

    public @NonNull YangInstanceIdentifier getRootIdentifier() {
        return this.rootIdentifier;
    }

    public boolean contains(DOMDataTreeIdentifier other) {
        return this.datastoreType == other.datastoreType && this.rootIdentifier.contains(other.rootIdentifier);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.datastoreType.hashCode();
        result = 31 * result + this.rootIdentifier.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DOMDataTreeIdentifier)) {
            return false;
        }
        DOMDataTreeIdentifier other = (DOMDataTreeIdentifier)obj;
        if (this.datastoreType != other.datastoreType) {
            return false;
        }
        return this.rootIdentifier.equals((Object)other.rootIdentifier);
    }

    @Override
    public int compareTo(DOMDataTreeIdentifier obj) {
        int cmp = this.datastoreType.compareTo((Enum)obj.datastoreType);
        if (cmp != 0) {
            return cmp;
        }
        Iterator mi = this.rootIdentifier.getPathArguments().iterator();
        Iterator oi = obj.rootIdentifier.getPathArguments().iterator();
        while (mi.hasNext()) {
            YangInstanceIdentifier.PathArgument oa;
            if (!oi.hasNext()) {
                return 1;
            }
            YangInstanceIdentifier.PathArgument ma = (YangInstanceIdentifier.PathArgument)mi.next();
            cmp = ma.compareTo((Object)(oa = (YangInstanceIdentifier.PathArgument)oi.next()));
            if (cmp == 0) continue;
            return cmp;
        }
        return oi.hasNext() ? -1 : 0;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("datastore", (Object)this.datastoreType).add("root", (Object)this.rootIdentifier).toString();
    }
}

