/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.api;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.concurrent.ThreadSafe;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;

@Beta
@ThreadSafe
public final class BindingRuntimeTypes
implements Immutable {
    private final ImmutableMap<Type, AugmentationSchemaNode> typeToAugmentation;
    private final ImmutableBiMap<Type, DocumentedNode.WithStatus> typeToSchema;
    private final ImmutableMultimap<Type, Type> choiceToCases;
    private final ImmutableMap<QName, Type> identities;

    public BindingRuntimeTypes(Map<Type, AugmentationSchemaNode> typeToAugmentation, BiMap<Type, DocumentedNode.WithStatus> typeToDefiningSchema, Multimap<Type, Type> choiceToCases, Map<QName, Type> identities) {
        this.typeToAugmentation = ImmutableMap.copyOf(typeToAugmentation);
        this.typeToSchema = ImmutableBiMap.copyOf(typeToDefiningSchema);
        this.choiceToCases = ImmutableMultimap.copyOf(choiceToCases);
        this.identities = ImmutableMap.copyOf(identities);
    }

    public Optional<AugmentationSchemaNode> findAugmentation(Type type) {
        return Optional.ofNullable(this.typeToAugmentation.get((Object)type));
    }

    public Optional<Type> findIdentity(QName qname) {
        return Optional.ofNullable(this.identities.get((Object)qname));
    }

    public Optional<DocumentedNode.WithStatus> findSchema(Type type) {
        return Optional.ofNullable(this.typeToSchema.get((Object)type));
    }

    public Optional<Type> findType(DocumentedNode.WithStatus schema) {
        return Optional.ofNullable(this.typeToSchema.inverse().get((Object)schema));
    }

    public Multimap<Type, Type> getChoiceToCases() {
        return this.choiceToCases;
    }

    public Collection<Type> findCases(Type choiceType) {
        return this.choiceToCases.get((Object)choiceType);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("typeToAugmentation", this.typeToAugmentation).add("typeToSchema", this.typeToSchema).add("choiceToCases", this.choiceToCases).add("identities", this.identities).toString();
    }
}

