/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.callhome.mount;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IetfInetUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfNode;

class ContextKey {
    private final IpAddress address;
    private final PortNumber port;

    ContextKey(IpAddress address, PortNumber port) {
        this.address = (IpAddress)Preconditions.checkNotNull((Object)address);
        this.port = (PortNumber)Preconditions.checkNotNull((Object)port);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.address.hashCode();
        result = 31 * result + this.port.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContextKey other = (ContextKey)obj;
        return Objects.equal((Object)this.address, (Object)other.address) && Objects.equal((Object)this.port, (Object)other.port);
    }

    IpAddress getIpAddress() {
        return this.address;
    }

    PortNumber getPort() {
        return this.port;
    }

    public static ContextKey from(NetconfNode node) {
        return new ContextKey(node.getHost().getIpAddress(), node.getPort());
    }

    public static ContextKey from(SocketAddress remoteAddress) {
        IpAddress yangIp;
        Preconditions.checkArgument((boolean)(remoteAddress instanceof InetSocketAddress));
        InetSocketAddress inetSocketAddr = (InetSocketAddress)remoteAddress;
        InetAddress ipAddress = inetSocketAddr.getAddress();
        if (ipAddress instanceof Inet4Address) {
            yangIp = new IpAddress((Ipv4Address)IetfInetUtil.INSTANCE.ipv4AddressFor(ipAddress));
        } else {
            Preconditions.checkArgument((boolean)(ipAddress instanceof Inet6Address));
            yangIp = new IpAddress((Ipv6Address)IetfInetUtil.INSTANCE.ipv6AddressFor(ipAddress));
        }
        return new ContextKey(yangIp, new PortNumber(Integer.valueOf(inetSocketAddr.getPort())));
    }

    public String toString() {
        if (this.address.getIpv4Address() != null) {
            return this.address.getIpv4Address().getValue() + ":" + this.port.getValue();
        }
        return this.address.getIpv6Address().getValue() + ":" + this.port.getValue();
    }
}

