/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.callhome.mount;

import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.DataObjectModification;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.DataTreeModification;
import org.opendaylight.mdsal.binding.api.ReadTransaction;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.netconf.callhome.mount.IetfZeroTouchCallHomeServerProvider;
import org.opendaylight.netconf.callhome.protocol.AuthorizedKeysDecoder;
import org.opendaylight.netconf.callhome.protocol.StatusRecorder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.callhome.device.status.rev170112.Device1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.callhome.device.status.rev170112.Device1Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfNodeConnectionStatus;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.network.topology.topology.topology.types.TopologyNetconf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netconf.callhome.server.rev161109.NetconfCallhomeServer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netconf.callhome.server.rev161109.netconf.callhome.server.AllowedDevices;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netconf.callhome.server.rev161109.netconf.callhome.server.allowed.devices.Device;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netconf.callhome.server.rev161109.netconf.callhome.server.allowed.devices.DeviceBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netconf.callhome.server.rev161109.netconf.callhome.server.allowed.devices.DeviceKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NetworkTopology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.TopologyKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeKey;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CallhomeStatusReporter
implements DataTreeChangeListener<Node>,
StatusRecorder,
AutoCloseable {
    private static final InstanceIdentifier<Topology> NETCONF_TOPO_IID = InstanceIdentifier.create(NetworkTopology.class).child(Topology.class, (Identifier)new TopologyKey(new TopologyId(TopologyNetconf.QNAME.getLocalName())));
    private static final Logger LOG = LoggerFactory.getLogger(CallhomeStatusReporter.class);
    private final DataBroker dataBroker;
    private final ListenerRegistration<CallhomeStatusReporter> reg;

    CallhomeStatusReporter(DataBroker broker) {
        this.dataBroker = broker;
        this.reg = this.dataBroker.registerDataTreeChangeListener(DataTreeIdentifier.create((LogicalDatastoreType)LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)NETCONF_TOPO_IID.child(Node.class)), (DataTreeChangeListener)this);
    }

    public void onDataTreeChanged(Collection<DataTreeModification<Node>> changes) {
        block4: for (DataTreeModification<Node> change : changes) {
            DataObjectModification rootNode = change.getRootNode();
            InstanceIdentifier identifier = change.getRootPath().getRootIdentifier();
            switch (rootNode.getModificationType()) {
                case WRITE: 
                case SUBTREE_MODIFIED: {
                    if (!CallhomeStatusReporter.isNetconfNode((Node)rootNode.getDataAfter())) break;
                    NodeId nodeId = CallhomeStatusReporter.getNodeId(identifier);
                    if (nodeId == null) continue block4;
                    NetconfNode nnode = (NetconfNode)((Node)rootNode.getDataAfter()).augmentation(NetconfNode.class);
                    this.handledNetconfNode(nodeId, nnode);
                    break;
                }
                case DELETE: {
                    if (!CallhomeStatusReporter.isNetconfNode((Node)rootNode.getDataBefore())) break;
                    NodeId nodeId = CallhomeStatusReporter.getNodeId(identifier);
                    if (nodeId == null) continue block4;
                    this.handleDisconnectedNetconfNode(nodeId);
                    break;
                }
            }
        }
    }

    private static boolean isNetconfNode(Node node) {
        return node.augmentation(NetconfNode.class) != null;
    }

    private static NodeId getNodeId(InstanceIdentifier<?> path) {
        NodeKey key = (NodeKey)path.firstKeyOf(Node.class);
        return key != null ? key.getNodeId() : null;
    }

    private void handledNetconfNode(NodeId nodeId, NetconfNode nnode) {
        NetconfNodeConnectionStatus.ConnectionStatus csts = nnode.getConnectionStatus();
        switch (csts) {
            case Connected: {
                this.handleConnectedNetconfNode(nodeId);
                break;
            }
            default: {
                this.handleUnableToConnectNetconfNode(nodeId);
            }
        }
    }

    private void handleConnectedNetconfNode(NodeId nodeId) {
        LOG.debug("NETCONF Node: {} is fully connected", (Object)nodeId.getValue());
        Device opDev = this.readAndGetDevice(nodeId);
        if (opDev == null) {
            LOG.info("No corresponding callhome device found - exiting. {} connected.", (Object)nodeId.getValue());
        } else {
            Device modifiedDevice = CallhomeStatusReporter.withConnectedStatus(opDev);
            if (modifiedDevice == null) {
                return;
            }
            LOG.info("Setting successful status for callhome device id:{}.", (Object)nodeId);
            this.writeDevice(nodeId, modifiedDevice);
        }
    }

    private void handleDisconnectedNetconfNode(NodeId nodeId) {
        LOG.debug("NETCONF Node: {} disconnected", (Object)nodeId.getValue());
        Device opDev = this.readAndGetDevice(nodeId);
        if (opDev == null) {
            LOG.info("No corresponding callhome device found - exiting. {} disconnected.", (Object)nodeId.getValue());
        } else {
            Device modifiedDevice = CallhomeStatusReporter.withDisconnectedStatus(opDev);
            if (modifiedDevice == null) {
                return;
            }
            LOG.info("Setting disconnected status for callhome device id:{}.", (Object)nodeId);
            this.writeDevice(nodeId, modifiedDevice);
        }
    }

    private void handleUnableToConnectNetconfNode(NodeId nodeId) {
        LOG.debug("NETCONF Node: {} connection failed", (Object)nodeId.getValue());
        Device opDev = this.readAndGetDevice(nodeId);
        if (opDev == null) {
            LOG.info("No corresponding callhome device found - exiting. {} unable to connect.", (Object)nodeId.getValue());
        } else {
            Device modifiedDevice = CallhomeStatusReporter.withFailedStatus(opDev);
            if (modifiedDevice == null) {
                return;
            }
            LOG.info("Setting failed status for callhome device id:{}.", (Object)nodeId);
            this.writeDevice(nodeId, modifiedDevice);
        }
    }

    void asForceListedDevice(String id, PublicKey serverKey) {
        NodeId nid = new NodeId(id);
        Device device = CallhomeStatusReporter.newDevice(id, serverKey, Device1.DeviceStatus.DISCONNECTED);
        this.writeDevice(nid, device);
    }

    String asForceListedDevice(PublicKey serverKey) {
        String sshEncodedKey = serverKey.toString();
        try {
            sshEncodedKey = AuthorizedKeysDecoder.encodePublicKey((PublicKey)serverKey);
        }
        catch (IOException e) {
            LOG.warn("Unable to encode public key to ssh format.", (Throwable)e);
        }
        String uniqueId = this.md5(sshEncodedKey);
        Device1 d1 = new Device1Builder().setDeviceStatus(Device1.DeviceStatus.DISCONNECTED).build();
        DeviceBuilder builder = new DeviceBuilder().setUniqueId(uniqueId).withKey(new DeviceKey(uniqueId)).setSshHostKey(sshEncodedKey).addAugmentation(Device1.class, (Augmentation)d1);
        Device device = builder.build();
        this.writeDevice(new NodeId(device.getUniqueId()), device);
        return uniqueId;
    }

    String md5(String plainText) {
        try {
            byte[] cipheText = MessageDigest.getInstance("MD5").digest(plainText.getBytes("UTF-8"));
            return ByteUtils.toHexString((byte[])cipheText);
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            LOG.error("md5 failed!", (Throwable)e);
            return null;
        }
    }

    void asUnlistedDevice(String id, PublicKey serverKey) {
        NodeId nid = new NodeId(id);
        Device device = CallhomeStatusReporter.newDevice(id, serverKey, Device1.DeviceStatus.FAILEDNOTALLOWED);
        this.writeDevice(nid, device);
    }

    private static Device newDevice(String id, PublicKey serverKey, Device1.DeviceStatus status) {
        String sshEncodedKey = serverKey.toString();
        try {
            sshEncodedKey = AuthorizedKeysDecoder.encodePublicKey((PublicKey)serverKey);
        }
        catch (IOException e) {
            LOG.warn("Unable to encode public key to ssh format.", (Throwable)e);
        }
        Device1 d1 = new Device1Builder().setDeviceStatus(Device1.DeviceStatus.FAILEDNOTALLOWED).build();
        DeviceBuilder builder = new DeviceBuilder().setUniqueId(id).withKey(new DeviceKey(id)).setSshHostKey(sshEncodedKey).addAugmentation(Device1.class, (Augmentation)d1);
        return builder.build();
    }

    private Device readAndGetDevice(NodeId nodeId) {
        return this.readDevice(nodeId).orElse(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<Device> readDevice(NodeId nodeId) {
        InstanceIdentifier<Device> deviceIID = CallhomeStatusReporter.buildDeviceInstanceIdentifier(nodeId);
        try (ReadTransaction opTx = this.dataBroker.newReadOnlyTransaction();){
            FluentFuture devFuture = opTx.read(LogicalDatastoreType.OPERATIONAL, deviceIID);
            Optional optional = (Optional)devFuture.get();
            return optional;
        }
        catch (InterruptedException | ExecutionException e) {
            return Optional.empty();
        }
    }

    private void writeDevice(NodeId nodeId, Device modifiedDevice) {
        WriteTransaction opTx = this.dataBroker.newWriteOnlyTransaction();
        opTx.merge(LogicalDatastoreType.OPERATIONAL, CallhomeStatusReporter.buildDeviceInstanceIdentifier(nodeId), (DataObject)modifiedDevice);
        CallhomeStatusReporter.commit(opTx, modifiedDevice.key());
    }

    void removeDevice(Device removedDevice) {
        NodeId nodeId = new NodeId(removedDevice.getUniqueId());
        WriteTransaction opTx = this.dataBroker.newWriteOnlyTransaction();
        opTx.delete(LogicalDatastoreType.OPERATIONAL, CallhomeStatusReporter.buildDeviceInstanceIdentifier(nodeId));
        CallhomeStatusReporter.commit(opTx, removedDevice.key());
    }

    void enableDevice(Device device) {
        NodeId nodeId = new NodeId(device.getUniqueId());
        WriteTransaction opTx = this.dataBroker.newWriteOnlyTransaction();
        opTx.merge(LogicalDatastoreType.CONFIGURATION, CallhomeStatusReporter.buildDeviceInstanceIdentifier(nodeId), (DataObject)device);
        CallhomeStatusReporter.commit(opTx, device.key());
    }

    private static InstanceIdentifier<Device> buildDeviceInstanceIdentifier(NodeId nodeId) {
        return InstanceIdentifier.create(NetconfCallhomeServer.class).child(AllowedDevices.class).child(Device.class, (Identifier)new DeviceKey(nodeId.getValue()));
    }

    private static Device withConnectedStatus(Device opDev) {
        Device1 status = new Device1Builder().setDeviceStatus(Device1.DeviceStatus.CONNECTED).build();
        return new DeviceBuilder().addAugmentation(Device1.class, (Augmentation)status).setUniqueId(opDev.getUniqueId()).setSshHostKey(opDev.getSshHostKey()).build();
    }

    private static Device withFailedStatus(Device opDev) {
        Device1 status = new Device1Builder().setDeviceStatus(Device1.DeviceStatus.FAILED).build();
        return new DeviceBuilder().addAugmentation(Device1.class, (Augmentation)status).setUniqueId(opDev.getUniqueId()).setSshHostKey(opDev.getSshHostKey()).build();
    }

    private static Device withDisconnectedStatus(Device opDev) {
        Device1 status = new Device1Builder().setDeviceStatus(Device1.DeviceStatus.DISCONNECTED).build();
        return new DeviceBuilder().addAugmentation(Device1.class, (Augmentation)status).setUniqueId(opDev.getUniqueId()).setSshHostKey(opDev.getSshHostKey()).build();
    }

    private static Device withFailedAuthStatus(Device opDev) {
        Device1 status = new Device1Builder().setDeviceStatus(Device1.DeviceStatus.FAILEDAUTHFAILURE).build();
        return new DeviceBuilder().addAugmentation(Device1.class, (Augmentation)status).setUniqueId(opDev.getUniqueId()).setSshHostKey(opDev.getSshHostKey()).build();
    }

    private void setDeviceStatus(Device device) {
        WriteTransaction tx = this.dataBroker.newWriteOnlyTransaction();
        KeyedInstanceIdentifier deviceIId = InstanceIdentifier.create(NetconfCallhomeServer.class).child(AllowedDevices.class).child(Device.class, (Identifier)device.key());
        tx.merge(LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)deviceIId, (DataObject)device);
        CallhomeStatusReporter.commit(tx, device.key());
    }

    private static void commit(WriteTransaction tx, final DeviceKey device) {
        tx.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                LOG.debug("Device {} committed", (Object)device);
            }

            public void onFailure(Throwable cause) {
                LOG.warn("Failed to commit device {}", (Object)device, (Object)cause);
            }
        }, MoreExecutors.directExecutor());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AllowedDevices getDevices() {
        try (ReadTransaction rxTransaction = this.dataBroker.newReadOnlyTransaction();){
            AllowedDevices allowedDevices = ((Optional)rxTransaction.read(LogicalDatastoreType.OPERATIONAL, IetfZeroTouchCallHomeServerProvider.ALL_DEVICES).get()).orElse(null);
            return allowedDevices;
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Error trying to read the whitelist devices", (Throwable)e);
            return null;
        }
    }

    private List<Device> getDevicesAsList() {
        AllowedDevices devices = this.getDevices();
        return devices == null ? new ArrayList() : devices.getDevice();
    }

    public void reportFailedAuth(PublicKey sshKey) {
        AuthorizedKeysDecoder decoder = new AuthorizedKeysDecoder();
        for (Device device : this.getDevicesAsList()) {
            String keyString = device.getSshHostKey();
            if (keyString == null) {
                LOG.info("Whitelist device {} does not have a host key, skipping it", (Object)device.getUniqueId());
                continue;
            }
            try {
                PublicKey pubKey = decoder.decodePublicKey(keyString);
                if (!sshKey.getAlgorithm().equals(pubKey.getAlgorithm()) || !sshKey.equals(pubKey)) continue;
                Device failedDevice = CallhomeStatusReporter.withFailedAuthStatus(device);
                if (failedDevice == null) {
                    return;
                }
                LOG.info("Setting auth failed status for callhome device id:{}.", (Object)failedDevice.getUniqueId());
                this.setDeviceStatus(failedDevice);
                return;
            }
            catch (GeneralSecurityException e) {
                LOG.error("Failed decoding a device key with host key: {}", (Object)keyString, (Object)e);
                return;
            }
        }
        LOG.error("No match found for the failed auth device (should have been filtered by whitelist). Key: {}", (Object)sshKey);
    }

    @Override
    public void close() {
        this.reg.close();
    }
}

