/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.callhome.mount;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.netty.util.concurrent.Promise;
import org.opendaylight.netconf.api.NetconfMessage;
import org.opendaylight.netconf.api.NetconfSession;
import org.opendaylight.netconf.api.NetconfTerminationReason;
import org.opendaylight.netconf.callhome.mount.CallHomeMountProperties;
import org.opendaylight.netconf.callhome.mount.ContextKey;
import org.opendaylight.netconf.callhome.protocol.CallHomeChannelActivator;
import org.opendaylight.netconf.callhome.protocol.CallHomeProtocolSessionContext;
import org.opendaylight.netconf.client.NetconfClientSession;
import org.opendaylight.netconf.client.NetconfClientSessionListener;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Host;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfNodeBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.credentials.Credentials;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.credentials.credentials.LoginPasswordBuilder;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeBuilder;
import org.opendaylight.yangtools.yang.binding.Augmentation;

class CallHomeMountSessionContext {
    private final NodeId nodeId;
    private final CallHomeChannelActivator activator;
    private final CallHomeProtocolSessionContext protocol;
    private final CloseCallback onClose;
    private final ContextKey key;

    CallHomeMountSessionContext(String nodeId, CallHomeProtocolSessionContext protocol, CallHomeChannelActivator activator, CloseCallback callback) {
        this.nodeId = new NodeId((String)Preconditions.checkNotNull((Object)nodeId, (Object)"nodeId"));
        this.key = ContextKey.from(protocol.getRemoteAddress());
        this.protocol = (CallHomeProtocolSessionContext)Preconditions.checkNotNull((Object)protocol, (Object)"protocol");
        this.activator = (CallHomeChannelActivator)Preconditions.checkNotNull((Object)activator, (Object)"activator");
        this.onClose = (CloseCallback)Preconditions.checkNotNull((Object)callback, (Object)"callback");
    }

    CallHomeProtocolSessionContext getProtocol() {
        return this.protocol;
    }

    NodeId getId() {
        return this.nodeId;
    }

    public ContextKey getContextKey() {
        return this.key;
    }

    Node getConfigNode() {
        NodeBuilder builder = new NodeBuilder();
        return builder.setNodeId(this.getId()).addAugmentation(NetconfNode.class, (Augmentation)this.configNetconfNode()).build();
    }

    private NetconfNode configNetconfNode() {
        NetconfNodeBuilder node = new NetconfNodeBuilder();
        node.setHost(new Host(this.key.getIpAddress()));
        node.setPort(this.key.getPort());
        node.setTcpOnly(CallHomeMountProperties.USER_DEFINED.getTcpOnly());
        node.setCredentials((Credentials)new LoginPasswordBuilder().setUsername("").setPassword("").build());
        node.setSchemaless(CallHomeMountProperties.USER_DEFINED.getSchemaLess());
        node.setKeepaliveDelay(CallHomeMountProperties.USER_DEFINED.getKeepalive());
        node.setDefaultRequestTimeoutMillis(CallHomeMountProperties.USER_DEFINED.getRequestTimeout());
        node.setConcurrentRpcLimit(CallHomeMountProperties.USER_DEFINED.getConcurrentRpcLimit());
        node.setReconnectOnChangedSchema(CallHomeMountProperties.USER_DEFINED.getSubscribe());
        return node.build();
    }

    <V> Promise<V> activateNetconfChannel(NetconfClientSessionListener sessionListener) {
        return this.activator.activate(this.wrap(sessionListener));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("address", (Object)this.protocol.getRemoteAddress()).add("hostKey", (Object)this.protocol.getRemoteServerKey()).toString();
    }

    private NetconfClientSessionListener wrap(final NetconfClientSessionListener delegate) {
        return new NetconfClientSessionListener(){

            public void onSessionUp(NetconfClientSession session) {
                delegate.onSessionUp((NetconfSession)session);
            }

            public void onSessionTerminated(NetconfClientSession session, NetconfTerminationReason reason) {
                try {
                    delegate.onSessionTerminated((NetconfSession)session, reason);
                }
                finally {
                    CallHomeMountSessionContext.this.removeSelf();
                }
            }

            public void onSessionDown(NetconfClientSession session, Exception exc) {
                try {
                    CallHomeMountSessionContext.this.removeSelf();
                }
                finally {
                    delegate.onSessionDown((NetconfSession)session, exc);
                }
            }

            public void onMessage(NetconfClientSession session, NetconfMessage message) {
                delegate.onMessage((NetconfSession)session, message);
            }
        };
    }

    private void removeSelf() {
        this.onClose.onClosed(this);
    }

    @FunctionalInterface
    public static interface CloseCallback {
        public void onClosed(CallHomeMountSessionContext var1);
    }
}

