/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.topology.impl;

import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NetworkTopology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.TopologyKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeKey;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;

public final class TopologyUtil {
    private TopologyUtil() {
        throw new AssertionError((Object)"Instantiating utility class.");
    }

    public static NodeId getNodeId(InstanceIdentifier.PathArgument pathArgument) {
        Identifier key;
        if (pathArgument instanceof InstanceIdentifier.IdentifiableItem && (key = ((InstanceIdentifier.IdentifiableItem)pathArgument).getKey()) instanceof NodeKey) {
            return ((NodeKey)key).getNodeId();
        }
        throw new IllegalStateException("Unable to create NodeId from: " + pathArgument);
    }

    public static KeyedInstanceIdentifier<Topology, TopologyKey> createTopologyListPath(String topologyId) {
        InstanceIdentifier networkTopology = InstanceIdentifier.create(NetworkTopology.class);
        return networkTopology.child(Topology.class, (Identifier)new TopologyKey(new TopologyId(topologyId)));
    }
}

